/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CodeSearchSupport {
    EXPLICIT,
    ALL,
    NULL;


    public static CodeSearchSupport fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("explicit".equals(codeString)) {
            return EXPLICIT;
        }
        if ("all".equals(codeString)) {
            return ALL;
        }
        throw new FHIRException("Unknown CodeSearchSupport code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EXPLICIT: {
                return "explicit";
            }
            case ALL: {
                return "all";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/code-search-support";
    }

    public String getDefinition() {
        switch (this) {
            case EXPLICIT: {
                return "The search for code on ValueSet only includes codes explicitly detailed on includes or expansions.";
            }
            case ALL: {
                return "The search for code on ValueSet only includes all codes based on the expansion of the value set.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EXPLICIT: {
                return "Explicit Codes";
            }
            case ALL: {
                return "Implicit Codes";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

