/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableGenerate<T, S>
extends Flowable<T> {
    final Supplier<S> stateSupplier;
    final BiFunction<S, Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;

    public FlowableGenerate(Supplier<S> stateSupplier, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
        this.disposeState = disposeState;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        S state;
        try {
            state = this.stateSupplier.get();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s2);
            return;
        }
        s2.onSubscribe(new GeneratorSubscription<T, S>(s2, this.generator, this.disposeState, state));
    }

    static final class GeneratorSubscription<T, S>
    extends AtomicLong
    implements Emitter<T>,
    Subscription {
        private static final long serialVersionUID = 7565982551505011832L;
        final Subscriber<? super T> downstream;
        final BiFunction<S, ? super Emitter<T>, S> generator;
        final Consumer<? super S> disposeState;
        S state;
        volatile boolean cancelled;
        boolean terminate;
        boolean hasNext;

        GeneratorSubscription(Subscriber<? super T> actual, BiFunction<S, ? super Emitter<T>, S> generator, Consumer<? super S> disposeState, S initialState) {
            this.downstream = actual;
            this.generator = generator;
            this.disposeState = disposeState;
            this.state = initialState;
        }

        @Override
        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            if (BackpressureHelper.add(this, n) != 0L) {
                return;
            }
            long e = 0L;
            S s2 = this.state;
            BiFunction<S, Emitter<T>, S> f = this.generator;
            while (true) {
                if (e != n) {
                    if (this.cancelled) {
                        this.state = null;
                        this.dispose(s2);
                        return;
                    }
                    this.hasNext = false;
                    try {
                        s2 = f.apply(s2, this);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelled = true;
                        this.state = null;
                        this.onError(ex);
                        this.dispose(s2);
                        return;
                    }
                    if (this.terminate) {
                        this.cancelled = true;
                        this.state = null;
                        this.dispose(s2);
                        return;
                    }
                    ++e;
                    continue;
                }
                n = this.get();
                if (e != n) continue;
                this.state = s2;
                n = this.addAndGet(-e);
                if (n == 0L) break;
                e = 0L;
            }
        }

        private void dispose(S s2) {
            try {
                this.disposeState.accept(s2);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (BackpressureHelper.add(this, 1L) == 0L) {
                    S s2 = this.state;
                    this.state = null;
                    this.dispose(s2);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.terminate) {
                if (this.hasNext) {
                    this.onError(new IllegalStateException("onNext already called in this generate turn"));
                } else if (t == null) {
                    this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                } else {
                    this.hasNext = true;
                    this.downstream.onNext(t);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.terminate) {
                RxJavaPlugins.onError(t);
            } else {
                if (t == null) {
                    t = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
                }
                this.terminate = true;
                this.downstream.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.terminate) {
                this.terminate = true;
                this.downstream.onComplete();
            }
        }
    }
}

