/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.i18n.Msg;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(TestUtil.class);
    private static boolean ourShouldRandomizeTimezones = true;

    public static void setShouldRandomizeTimezones(boolean theShouldRandomizeTimezones) {
        ourShouldRandomizeTimezones = theShouldRandomizeTimezones;
    }

    public static void randomizeLocaleAndTimezone() {
        HapiLocalizer.setOurFailOnMissingMessage(true);
        TestUtil.doRandomizeLocaleAndTimezone();
    }

    public static void doRandomizeLocaleAndTimezone() {
        Locale[] availableLocales = new Locale[]{Locale.US};
        Locale.setDefault(availableLocales[(int)(Math.random() * (double)availableLocales.length)]);
        ourLog.info("Tests are running in locale: " + Locale.getDefault().getDisplayName());
        if (Math.random() < 0.5) {
            ourLog.info("Tests are using WINDOWS line endings and ISO-8851-1");
            System.setProperty("file.encoding", "ISO-8859-1");
            System.setProperty("line.separator", "\r\n");
        } else {
            ourLog.info("Tests are using UNIX line endings and UTF-8");
            System.setProperty("file.encoding", "UTF-8");
            System.setProperty("line.separator", "\n");
        }
        if (ourShouldRandomizeTimezones) {
            String[] availableTimeZones = new String[]{"GMT+08:00", "GMT-05:00", "GMT+00:00", "GMT+03:30"};
            String timeZone = availableTimeZones[(int)(Math.random() * (double)availableTimeZones.length)];
            TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
        }
        ourLog.info("Tests are using time zone: {}", (Object)TimeZone.getDefault().getID());
    }

    public static void waitForSize(int theTarget, AtomicInteger theInteger) {
        long start = System.currentTimeMillis();
        while (theInteger.get() != theTarget && System.currentTimeMillis() - start <= 15000L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException theE) {
                throw new Error(Msg.code(1778) + theE);
            }
        }
        if (System.currentTimeMillis() - start >= 15000L) {
            throw new IllegalStateException(Msg.code(1779) + "Size " + theInteger.get() + " is != target " + theTarget);
        }
    }

    public static void waitForSize(int theTarget, Callable<Integer> theSource) throws Exception {
        long start = System.currentTimeMillis();
        while (theSource.call() != theTarget && System.currentTimeMillis() - start <= 15000L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException theE) {
                throw new Error(Msg.code(1780) + theE);
            }
        }
        if (System.currentTimeMillis() - start >= 15000L) {
            throw new IllegalStateException(Msg.code(1781) + "Size " + theSource.call() + " is != target " + theTarget);
        }
    }

    public static String stripReturns(String theString) {
        return StringUtils.defaultString(theString).replace("\r", "");
    }

    public static String stripWhitespace(String theString) {
        return TestUtil.stripReturns(theString).replace(" ", "");
    }

    public static void sleepAtLeast(long theMillis) {
        TestUtil.sleepAtLeast(theMillis, true);
    }

    public static void sleepAtLeast(long theMillis, boolean theLogProgress) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() <= start + theMillis) {
            try {
                long timeSinceStarted = System.currentTimeMillis() - start;
                long timeToSleep = Math.max(0L, theMillis - timeSinceStarted);
                if (theLogProgress) {
                    ourLog.info("Sleeping for {}ms", (Object)timeToSleep);
                }
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ourLog.error("Interrupted", e);
            }
        }
    }
}

