/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.impl;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.impl.BaseClient;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.impl.ClientInvocationHandlerFactory;
import ca.uhn.fhir.rest.client.impl.RestfulClientFactory;
import ca.uhn.fhir.rest.client.method.BaseMethodBinding;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

public class ClientInvocationHandler
extends BaseClient
implements InvocationHandler {
    private final Map<Method, BaseMethodBinding<?>> myBindings;
    private final Map<Method, Object> myMethodToReturnValue;
    private FhirContext myContext;
    private Map<Method, ClientInvocationHandlerFactory.ILambda> myMethodToLambda;

    public ClientInvocationHandler(IHttpClient theClient, FhirContext theContext, String theUrlBase, Map<Method, Object> theMethodToReturnValue, Map<Method, BaseMethodBinding<?>> theBindings, Map<Method, ClientInvocationHandlerFactory.ILambda> theMethodToLambda, RestfulClientFactory theFactory) {
        super(theClient, theUrlBase, theFactory);
        this.myContext = theContext;
        this.myMethodToReturnValue = theMethodToReturnValue;
        this.myBindings = theBindings;
        this.myMethodToLambda = theMethodToLambda;
    }

    public void addBinding(Method theMethod, BaseMethodBinding<?> theBinding) {
        this.myBindings.put(theMethod, theBinding);
    }

    @Override
    public Object invoke(Object theProxy, Method theMethod, Object[] theArgs) throws Throwable {
        Object directRetVal = this.myMethodToReturnValue.get(theMethod);
        if (directRetVal != null) {
            return directRetVal;
        }
        BaseMethodBinding<?> binding = this.myBindings.get(theMethod);
        if (binding != null) {
            BaseHttpClientInvocation clientInvocation = binding.invokeClient(theArgs);
            return this.invokeClient(this.myContext, binding, clientInvocation);
        }
        ClientInvocationHandlerFactory.ILambda lambda2 = this.myMethodToLambda.get(theMethod);
        if (lambda2 != null) {
            return lambda2.handle(this, theArgs);
        }
        throw new UnsupportedOperationException(Msg.code(1403) + "The method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getSimpleName() + " has no handler. Did you forget to annotate it with a RESTful method annotation?");
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myContext;
    }
}

