/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.util.CoverageIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class MethodOutcome {
    private Boolean myCreated;
    private IIdType myId;
    private IBaseOperationOutcome myOperationOutcome;
    private IBaseResource myResource;
    private Map<String, List<String>> myResponseHeaders;
    private Collection<Runnable> myResourceViewCallbacks;
    private int myResponseStatusCode;

    public MethodOutcome() {
    }

    @CoverageIgnore
    public MethodOutcome(IIdType theId, Boolean theCreated) {
        this.myId = theId;
        this.myCreated = theCreated;
    }

    public MethodOutcome(IIdType theId, IBaseOperationOutcome theBaseOperationOutcome) {
        this.myId = theId;
        this.myOperationOutcome = theBaseOperationOutcome;
    }

    public MethodOutcome(IIdType theId, IBaseOperationOutcome theBaseOperationOutcome, Boolean theCreated) {
        this.myId = theId;
        this.myOperationOutcome = theBaseOperationOutcome;
        this.myCreated = theCreated;
    }

    public MethodOutcome(IIdType theId) {
        this.myId = theId;
    }

    public MethodOutcome(IBaseOperationOutcome theOperationOutcome) {
        this.myOperationOutcome = theOperationOutcome;
    }

    public Boolean getCreated() {
        return this.myCreated;
    }

    public MethodOutcome setCreated(Boolean theCreated) {
        this.myCreated = theCreated;
        return this;
    }

    public IIdType getId() {
        return this.myId;
    }

    public MethodOutcome setId(IIdType theId) {
        this.myId = theId;
        return this;
    }

    public IBaseOperationOutcome getOperationOutcome() {
        return this.myOperationOutcome;
    }

    public MethodOutcome setOperationOutcome(IBaseOperationOutcome theBaseOperationOutcome) {
        this.myOperationOutcome = theBaseOperationOutcome;
        return this;
    }

    public IBaseResource getResource() {
        return this.myResource;
    }

    public MethodOutcome setResource(IBaseResource theResource) {
        this.myResource = theResource;
        return this;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.myResponseHeaders;
    }

    public void setResponseHeaders(Map<String, List<String>> theResponseHeaders) {
        this.myResponseHeaders = theResponseHeaders;
    }

    public void registerResourceViewCallback(Runnable theCallback) {
        Validate.notNull(theCallback, "theCallback must not be null", new Object[0]);
        if (this.myResourceViewCallbacks == null) {
            this.myResourceViewCallbacks = new ArrayList<Runnable>(2);
        }
        this.myResourceViewCallbacks.add(theCallback);
    }

    public void fireResourceViewCallbacks() {
        if (this.myResourceViewCallbacks != null) {
            this.myResourceViewCallbacks.forEach(t -> t.run());
            this.myResourceViewCallbacks.clear();
        }
    }

    public void setCreatedUsingStatusCode(int theResponseStatusCode) {
        if (theResponseStatusCode == 201) {
            this.setCreated(true);
        }
    }

    protected boolean hasResource() {
        return this.myResource != null;
    }

    public void setStatusCode(int theResponseStatusCode) {
        this.myResponseStatusCode = theResponseStatusCode;
    }

    public int getResponseStatusCode() {
        return this.myResponseStatusCode;
    }
}

