/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.validation;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public final class ValidationUtils {
    private static final ValidatorFactory DEFAULT_VALIDATION_FACTORY = Validation.buildDefaultValidatorFactory();

    private ValidationUtils() {
    }

    @Nonnull
    public static <T> Set<ConstraintViolation<T>> validate(@Nonnull T bean) {
        Validator validator = DEFAULT_VALIDATION_FACTORY.getValidator();
        return validator.validate(bean, new Class[0]);
    }

    @Nonnull
    public static <T> T ensureValid(@Nonnull T bean, @Nonnull String message) throws ConstraintViolationException {
        Set<ConstraintViolation<T>> constraintViolations = ValidationUtils.validate(bean);
        if (!constraintViolations.isEmpty()) {
            ValidationUtils.failValidation(constraintViolations, message);
        }
        return bean;
    }

    public static void failValidation(@Nonnull Set<? extends ConstraintViolation<?>> constraintViolations, @Nullable String messageTitle) throws ConstraintViolationException {
        String exceptionMessage = Objects.nonNull(messageTitle) ? messageTitle + ": " + ValidationUtils.formatViolations(constraintViolations) : ValidationUtils.formatViolations(constraintViolations);
        throw new ConstraintViolationException(exceptionMessage, constraintViolations);
    }

    @Nonnull
    public static String formatViolations(@Nonnull Set<? extends ConstraintViolation<?>> constraintViolations) {
        return constraintViolations.stream().map(cv -> cv == null ? "null" : cv.getPropertyPath() + ": " + cv.getMessage()).sorted().collect(Collectors.joining(", "));
    }
}

