/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology.validatecode;

import au.csiro.pathling.fhir.ParametersUtils;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.terminology.TerminologyOperation;
import au.csiro.pathling.terminology.TerminologyParameters;
import au.csiro.pathling.terminology.validatecode.ValidateCodeParameters;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;

public class ValidateCodeExecutor
implements TerminologyOperation<Parameters, Boolean> {
    @Nonnull
    private final TerminologyClient terminologyClient;
    @Nonnull
    private final ValidateCodeParameters parameters;

    public ValidateCodeExecutor(@Nonnull TerminologyClient terminologyClient, @Nonnull ValidateCodeParameters parameters) {
        this.terminologyClient = terminologyClient;
        this.parameters = parameters;
    }

    @Override
    @Nonnull
    public Optional<Boolean> validate() {
        ImmutableCoding coding = this.parameters.getCoding();
        if (Objects.isNull(coding.getSystem()) || Objects.isNull(coding.getCode())) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildRequest() {
        String codeSystemUrl = this.parameters.getValueSetUrl();
        ImmutableCoding coding = this.parameters.getCoding();
        return this.terminologyClient.buildValidateCode(TerminologyParameters.required(UriType::new, codeSystemUrl), TerminologyParameters.required(UriType::new, coding.getSystem()), TerminologyParameters.optional(StringType::new, coding.getVersion()), TerminologyParameters.required(CodeType::new, coding.getCode()));
    }

    @Override
    @Nonnull
    public Boolean extractResult(@Nonnull Parameters response) {
        return ParametersUtils.toBooleanResult(response);
    }

    @Override
    @Nonnull
    public Boolean invalidRequestFallback() {
        return false;
    }
}

