/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology.lookup;

import au.csiro.pathling.fhir.ParametersUtils;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.terminology.TerminologyOperation;
import au.csiro.pathling.terminology.TerminologyParameters;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.caching.CacheableListCollector;
import au.csiro.pathling.terminology.lookup.LookupParameters;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;

public class LookupExecutor
implements TerminologyOperation<Parameters, ArrayList<TerminologyService.PropertyOrDesignation>> {
    @Nonnull
    private final TerminologyClient terminologyClient;
    @Nonnull
    private final LookupParameters parameters;

    public LookupExecutor(@Nonnull TerminologyClient terminologyClient, @Nonnull LookupParameters parameters) {
        this.terminologyClient = terminologyClient;
        this.parameters = parameters;
    }

    @Override
    @Nonnull
    public Optional<ArrayList<TerminologyService.PropertyOrDesignation>> validate() {
        ImmutableCoding coding = this.parameters.getCoding();
        if (Objects.isNull(coding.getSystem()) || Objects.isNull(coding.getCode())) {
            return Optional.of(new ArrayList());
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildRequest() {
        ImmutableCoding coding = this.parameters.getCoding();
        String property = this.parameters.getProperty();
        return this.terminologyClient.buildLookup(TerminologyParameters.required(UriType::new, coding.getSystem()), TerminologyParameters.optional(StringType::new, coding.getVersion()), TerminologyParameters.required(CodeType::new, coding.getCode()), TerminologyParameters.optional(CodeType::new, property));
    }

    @Override
    @Nonnull
    public ArrayList<TerminologyService.PropertyOrDesignation> extractResult(@Nonnull Parameters response) {
        return LookupExecutor.toPropertiesAndDesignations(response, this.parameters.getProperty());
    }

    @Override
    @Nonnull
    public ArrayList<TerminologyService.PropertyOrDesignation> invalidRequestFallback() {
        return new ArrayList<TerminologyService.PropertyOrDesignation>();
    }

    @Nonnull
    private static ArrayList<TerminologyService.PropertyOrDesignation> toPropertiesAndDesignations(@Nonnull Parameters parameters, @Nullable String propertyCode) {
        return "designation".equals(propertyCode) ? LookupExecutor.toDesignations(parameters) : LookupExecutor.toProperties(parameters, propertyCode);
    }

    @Nonnull
    private static ArrayList<TerminologyService.PropertyOrDesignation> toDesignations(@Nonnull Parameters parameters) {
        return (ArrayList)ParametersUtils.toDesignations(parameters).map(TerminologyService.Designation::ofPart).collect(new CacheableListCollector());
    }

    @Nonnull
    private static ArrayList<TerminologyService.PropertyOrDesignation> toProperties(@Nonnull Parameters parameters, @Nullable String propertyCode) {
        return (ArrayList)ParametersUtils.toProperties(parameters).flatMap(part -> Objects.nonNull(part.getSubproperty()) ? part.getSubproperty().stream() : Stream.of(part)).map(part -> TerminologyService.Property.of((String)part.getCode().getValue(), Objects.requireNonNull(part.getValue()))).filter(property -> Objects.isNull(propertyCode) || propertyCode.equals(property.getCode())).collect(new CacheableListCollector());
    }
}

