/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhir.ParametersUtils;
import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.codesystems.ConceptMapEquivalence;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;

public interface TerminologyService {
    public boolean validateCode(@Nonnull String var1, @Nonnull Coding var2);

    @Nonnull
    public List<Translation> translate(@Nonnull Coding var1, @Nonnull String var2, boolean var3, @Nullable String var4);

    @Nonnull
    public ConceptSubsumptionOutcome subsumes(@Nonnull Coding var1, @Nonnull Coding var2);

    @Nonnull
    public List<PropertyOrDesignation> lookup(@Nonnull Coding var1, @Nullable String var2);

    public static final class Designation
    implements PropertyOrDesignation {
        private static final long serialVersionUID = -809107979219801186L;
        public static final String PROPERTY_CODE = "designation";
        @Nullable
        private final Coding use;
        @Nullable
        private final String language;
        @Nonnull
        private final String value;

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not implemented.");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Designation that = (Designation)o;
            if (this.use != null ? !this.use.equalsDeep(that.use) : that.use != null) {
                return false;
            }
            if (!Objects.equals(this.language, that.language)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        @Nonnull
        public static Designation ofPart(@Nonnull ParametersUtils.DesignationPart part) {
            return Designation.of(part.getUse(), Optional.ofNullable(part.getLanguage()).map(PrimitiveType::getValue).orElse(null), (String)part.getValue().getValue());
        }

        private Designation(@Nullable Coding use, @Nullable String language, @Nonnull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.use = use;
            this.language = language;
            this.value = value;
        }

        public static Designation of(@Nullable Coding use, @Nullable String language, @Nonnull String value) {
            return new Designation(use, language, value);
        }

        @Nullable
        public Coding getUse() {
            return this.use;
        }

        @Nullable
        public String getLanguage() {
            return this.language;
        }

        @Nonnull
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "TerminologyService.Designation(use=" + this.getUse() + ", language=" + this.getLanguage() + ", value=" + this.getValue() + ")";
        }
    }

    public static final class Property
    implements PropertyOrDesignation {
        private static final long serialVersionUID = 8827691056493768863L;
        @Nonnull
        private final String code;
        @Nonnull
        private final Type value;

        @Nonnull
        public String getValueAsString() {
            return this.value.primitiveValue();
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode not implemented.");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            if (!this.code.equals(property.code)) {
                return false;
            }
            return this.value.equalsDeep(property.value);
        }

        private Property(@Nonnull String code, @Nonnull Type value) {
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.code = code;
            this.value = value;
        }

        public static Property of(@Nonnull String code, @Nonnull Type value) {
            return new Property(code, value);
        }

        @Nonnull
        public String getCode() {
            return this.code;
        }

        @Nonnull
        public Type getValue() {
            return this.value;
        }

        public String toString() {
            return "TerminologyService.Property(code=" + this.getCode() + ", value=" + this.getValue() + ")";
        }
    }

    public static interface PropertyOrDesignation
    extends Serializable {
    }

    public static final class Translation
    implements Serializable {
        private static final long serialVersionUID = -7551505530196865478L;
        @Nonnull
        private final ConceptMapEquivalence equivalence;
        @Nonnull
        private final Coding concept;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Translation that = (Translation)o;
            return this.equivalence == that.equivalence && ImmutableCoding.of(this.concept).equals(ImmutableCoding.of(that.concept));
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.equivalence, ImmutableCoding.of(this.concept)});
        }

        private Translation(@Nonnull ConceptMapEquivalence equivalence, @Nonnull Coding concept) {
            if (equivalence == null) {
                throw new NullPointerException("equivalence is marked non-null but is null");
            }
            if (concept == null) {
                throw new NullPointerException("concept is marked non-null but is null");
            }
            this.equivalence = equivalence;
            this.concept = concept;
        }

        public static Translation of(@Nonnull ConceptMapEquivalence equivalence, @Nonnull Coding concept) {
            return new Translation(equivalence, concept);
        }

        @Nonnull
        public ConceptMapEquivalence getEquivalence() {
            return this.equivalence;
        }

        @Nonnull
        public Coding getConcept() {
            return this.concept;
        }

        public String toString() {
            return "TerminologyService.Translation(equivalence=" + this.getEquivalence() + ", concept=" + this.getConcept() + ")";
        }
    }
}

