/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql;

import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import au.csiro.pathling.sql.udf.PropertyUdf;
import au.csiro.pathling.utilities.Preconditions;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.codesystems.ConceptMapEquivalence;

public interface Terminology {
    @Nonnull
    public static Column member_of(@Nonnull Column coding, @Nonnull String valueSetUrl) {
        return Terminology.member_of(coding, functions.lit((Object)valueSetUrl));
    }

    @Nonnull
    public static Column member_of(@Nonnull Column coding, @Nonnull Column valueSetUrl) {
        return functions.call_udf((String)"member_of", (Column[])new Column[]{coding, valueSetUrl});
    }

    @Nonnull
    public static Column translate(@Nonnull Column coding, @Nonnull String conceptMapUri, boolean reverse, @Nullable Collection<ConceptMapEquivalence> equivalences, @Nullable String target) {
        return functions.call_udf((String)"translate_coding", (Column[])new Column[]{coding, functions.lit((Object)conceptMapUri), functions.lit((Object)reverse), Objects.nonNull(equivalences) ? functions.array((Column[])((Column[])equivalences.stream().distinct().map(ConceptMapEquivalence::toCode).map(functions::lit).toArray(Column[]::new))) : functions.lit(null), functions.lit((Object)target)});
    }

    @Nonnull
    public static Column translate(@Nonnull Column coding, @Nonnull String conceptMapUri, boolean reverse, @Nullable Collection<ConceptMapEquivalence> equivalences) {
        return Terminology.translate(coding, conceptMapUri, reverse, equivalences, null);
    }

    @Nonnull
    public static Column subsumes(@Nonnull Column codingA, @Nonnull Column codingB) {
        return functions.call_udf((String)"subsumes", (Column[])new Column[]{codingA, codingB, functions.lit((Object)false)});
    }

    @Nonnull
    public static Column subsumed_by(@Nonnull Column codingA, @Nonnull Column codingB) {
        return functions.call_udf((String)"subsumes", (Column[])new Column[]{codingA, codingB, functions.lit((Object)true)});
    }

    @Nonnull
    public static Column display(@Nonnull Column coding) {
        return functions.call_udf((String)"display", (Column[])new Column[]{coding});
    }

    @Nonnull
    public static Column property_of(@Nonnull Column coding, @Nonnull String propertyCode, @Nonnull Enumerations.FHIRDefinedType propertyType) {
        return functions.call_udf((String)PropertyUdf.getNameForType(propertyType), (Column[])new Column[]{coding, functions.lit((Object)propertyCode)});
    }

    @Nonnull
    public static Column property_of(@Nonnull Column coding, @Nonnull String propertyCode, @Nullable String propertyType) {
        return Terminology.property_of(coding, propertyCode, Objects.nonNull(propertyType) ? Preconditions.wrapInUserInputError(Enumerations.FHIRDefinedType::fromCode).apply(propertyType) : PropertyUdf.DEFAULT_PROPERTY_TYPE);
    }

    @Nonnull
    public static Column property_of(@Nonnull Column coding, @Nonnull String propertyCode) {
        return Terminology.property_of(coding, propertyCode, PropertyUdf.DEFAULT_PROPERTY_TYPE);
    }

    @Nonnull
    public static Column designation(@Nonnull Column coding, @Nonnull Column use, @Nullable String language) {
        return functions.call_udf((String)"designation", (Column[])new Column[]{coding, use, functions.lit((Object)language)});
    }

    @Nonnull
    public static Column designation(@Nonnull Column coding, @Nullable Coding use, @Nullable String language) {
        return Terminology.designation(coding, CodingEncoding.toLiteralColumn(use), language);
    }

    @Nonnull
    public static Column designation(@Nonnull Column coding, @Nullable Coding use) {
        return Terminology.designation(coding, use, null);
    }

    @Nonnull
    public static Column designation(@Nonnull Column coding) {
        return Terminology.designation(coding, null);
    }
}

