/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.library;

import au.csiro.pathling.config.EncodingConfiguration;
import au.csiro.pathling.config.TerminologyConfiguration;
import au.csiro.pathling.encoders.FhirEncoders;
import au.csiro.pathling.library.EncodeBundleMapPartitions;
import au.csiro.pathling.library.EncodeResourceMapPartitions;
import au.csiro.pathling.sql.udf.TerminologyUdfRegistrar;
import au.csiro.pathling.terminology.DefaultTerminologyServiceFactory;
import au.csiro.pathling.terminology.TerminologyFunctions;
import au.csiro.pathling.terminology.TerminologyServiceFactory;
import au.csiro.pathling.validation.ValidationUtils;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathlingContext {
    private static final Logger log = LoggerFactory.getLogger(PathlingContext.class);
    private static final String COL_INPUT_CODINGS = "inputCodings";
    private static final String COL_ARG_CODINGS = "argCodings";
    @Nonnull
    private final SparkSession spark;
    @Nonnull
    private final FhirVersionEnum fhirVersion;
    @Nonnull
    private final FhirEncoders fhirEncoders;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;
    @Nonnull
    private final TerminologyFunctions terminologyFunctions;

    private PathlingContext(@Nonnull SparkSession spark, @Nonnull FhirEncoders fhirEncoders, @Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        this.spark = spark;
        this.fhirVersion = fhirEncoders.getFhirVersion();
        this.fhirEncoders = fhirEncoders;
        this.terminologyServiceFactory = terminologyServiceFactory;
        this.terminologyFunctions = TerminologyFunctions.build();
        TerminologyUdfRegistrar.registerUdfs(spark, terminologyServiceFactory);
    }

    @Nonnull
    public static PathlingContext create(@Nonnull SparkSession spark, @Nonnull FhirEncoders fhirEncoders, @Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        return new PathlingContext(spark, fhirEncoders, terminologyServiceFactory);
    }

    @Nonnull
    public static PathlingContext create(@Nonnull SparkSession sparkSession, @Nonnull EncodingConfiguration encodingConfiguration, @Nonnull TerminologyConfiguration terminologyConfiguration) {
        ValidationUtils.ensureValid(terminologyConfiguration, "Invalid terminology configuration");
        ValidationUtils.ensureValid(encodingConfiguration, "Invalid encoding configuration");
        FhirEncoders.Builder encoderBuilder = PathlingContext.getEncoderBuilder(encodingConfiguration);
        TerminologyServiceFactory terminologyServiceFactory = PathlingContext.getTerminologyServiceFactory(terminologyConfiguration);
        return PathlingContext.create(sparkSession, encoderBuilder.getOrCreate(), terminologyServiceFactory);
    }

    @Nonnull
    public static PathlingContext create(@Nonnull SparkSession sparkSession) {
        EncodingConfiguration encodingConfig = EncodingConfiguration.builder().build();
        TerminologyConfiguration terminologyConfig = TerminologyConfiguration.builder().build();
        return PathlingContext.create(sparkSession, encodingConfig, terminologyConfig);
    }

    @Nonnull
    public static PathlingContext create(@Nonnull SparkSession sparkSession, @Nonnull EncodingConfiguration encodingConfig) {
        TerminologyConfiguration terminologyConfig = TerminologyConfiguration.builder().build();
        return PathlingContext.create(sparkSession, encodingConfig, terminologyConfig);
    }

    @Nonnull
    public static PathlingContext create(@Nonnull SparkSession sparkSession, @Nonnull TerminologyConfiguration terminologyConfig) {
        EncodingConfiguration encodingConfig = EncodingConfiguration.builder().build();
        return PathlingContext.create(sparkSession, encodingConfig, terminologyConfig);
    }

    @Nonnull
    public <T extends IBaseResource> Dataset<T> encode(@Nonnull Dataset<String> stringResources, @Nonnull Class<T> resourceClass, @Nonnull String inputMimeType) {
        return stringResources.mapPartitions(new EncodeResourceMapPartitions<T>(this.fhirVersion, inputMimeType, resourceClass), this.fhirEncoders.of(resourceClass));
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName, @Nonnull String inputMimeType, @Nullable String maybeColumnName) {
        Dataset stringResources = (Objects.nonNull(maybeColumnName) ? stringResourcesDF.select(maybeColumnName, new String[0]) : stringResourcesDF).as(Encoders.STRING());
        RuntimeResourceDefinition definition = FhirEncoders.contextFor(this.fhirVersion).getResourceDefinition(resourceName);
        return this.encode((Dataset<String>)stringResources, definition.getImplementingClass(), inputMimeType).toDF();
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName, @Nonnull String inputMimeType) {
        return this.encode(stringResourcesDF, resourceName, inputMimeType, null);
    }

    @Nonnull
    public Dataset<Row> encode(@Nonnull Dataset<Row> stringResourcesDF, @Nonnull String resourceName) {
        return this.encode(stringResourcesDF, resourceName, "application/fhir+json");
    }

    @Nonnull
    public <T extends IBaseResource> Dataset<T> encodeBundle(@Nonnull Dataset<String> stringBundles, @Nonnull Class<T> resourceClass, @Nonnull String inputMimeType) {
        return stringBundles.mapPartitions(new EncodeBundleMapPartitions<T>(this.fhirVersion, inputMimeType, resourceClass), this.fhirEncoders.of(resourceClass));
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName, @Nonnull String inputMimeType, @Nullable String maybeColumnName) {
        Dataset stringResources = (Objects.nonNull(maybeColumnName) ? stringBundlesDF.select(maybeColumnName, new String[0]) : stringBundlesDF).as(Encoders.STRING());
        RuntimeResourceDefinition definition = FhirEncoders.contextFor(this.fhirVersion).getResourceDefinition(resourceName);
        return this.encodeBundle((Dataset<String>)stringResources, definition.getImplementingClass(), inputMimeType).toDF();
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName, @Nonnull String inputMimeType) {
        return this.encodeBundle(stringBundlesDF, resourceName, inputMimeType, null);
    }

    @Nonnull
    public Dataset<Row> encodeBundle(@Nonnull Dataset<Row> stringBundlesDF, @Nonnull String resourceName) {
        return this.encodeBundle(stringBundlesDF, resourceName, "application/fhir+json");
    }

    @Nonnull
    public Dataset<Row> memberOf(@Nonnull Dataset<Row> dataset, @Nonnull Column coding, @Nonnull String valueSetUri, @Nonnull String outputColumnName) {
        Column codingArrayCol = functions.when((Column)coding.isNotNull(), (Object)functions.array((Column[])new Column[]{coding})).otherwise((Object)functions.lit(null));
        return this.terminologyFunctions.memberOf(codingArrayCol, valueSetUri, dataset, outputColumnName);
    }

    @Nonnull
    public Dataset<Row> translate(@Nonnull Dataset<Row> dataset, @Nonnull Column coding, @Nonnull String conceptMapUri, boolean reverse, @Nonnull String equivalence, @Nullable String target, @Nonnull String outputColumnName) {
        Column codingArrayCol = functions.when((Column)coding.isNotNull(), (Object)functions.array((Column[])new Column[]{coding})).otherwise((Object)functions.lit(null));
        Dataset<Row> translatedDataset = this.terminologyFunctions.translate(codingArrayCol, conceptMapUri, reverse, equivalence, target, dataset, outputColumnName);
        return translatedDataset.withColumn(outputColumnName, functions.col((String)outputColumnName));
    }

    @Nonnull
    public Dataset<Row> subsumes(@Nonnull Dataset<Row> dataset, @Nonnull Column leftCoding, @Nonnull Column rightCoding, @Nonnull String outputColumnName) {
        Column fromArray = functions.array((Column[])new Column[]{leftCoding});
        Column toArray = functions.array((Column[])new Column[]{rightCoding});
        Column fromCodings = functions.when((Column)leftCoding.isNotNull(), (Object)fromArray).otherwise(null);
        Column toCodings = functions.when((Column)rightCoding.isNotNull(), (Object)toArray).otherwise(null);
        Dataset idAndCodingSet = dataset.withColumn(COL_INPUT_CODINGS, fromCodings).withColumn(COL_ARG_CODINGS, toCodings);
        return this.terminologyFunctions.subsumes((Dataset<Row>)idAndCodingSet, idAndCodingSet.col(COL_INPUT_CODINGS), idAndCodingSet.col(COL_ARG_CODINGS), outputColumnName, false);
    }

    @Nonnull
    private static FhirEncoders.Builder getEncoderBuilder(@Nonnull EncodingConfiguration config) {
        return FhirEncoders.forR4().withMaxNestingLevel(config.getMaxNestingLevel()).withExtensionsEnabled(config.isEnableExtensions()).withOpenTypes(config.getOpenTypes());
    }

    @Nonnull
    private static TerminologyServiceFactory getTerminologyServiceFactory(@Nonnull TerminologyConfiguration configuration) {
        FhirVersionEnum fhirVersion = FhirContext.forR4().getVersion().getVersion();
        return new DefaultTerminologyServiceFactory(fhirVersion, configuration);
    }

    @Nonnull
    public SparkSession getSpark() {
        return this.spark;
    }

    @Nonnull
    public TerminologyServiceFactory getTerminologyServiceFactory() {
        return this.terminologyServiceFactory;
    }
}

