/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.encoders.terminology.ucum;

import java.io.InputStream;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fhir.ucum.Decimal;
import org.fhir.ucum.Pair;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumService;

public class Ucum {
    public static final String NO_UNIT_CODE = "1";
    public static final String SYSTEM_URI = "http://unitsofmeasure.org";
    private static final UcumService service;

    @Nonnull
    public static UcumService service() throws UcumException {
        return service;
    }

    @Nullable
    public static BigDecimal getCanonicalValue(@Nullable BigDecimal value, @Nullable String code) {
        try {
            Pair result = Ucum.getCanonicalForm(value, code);
            if (result == null) {
                return null;
            }
            Decimal decimalValue = result.getValue();
            if (decimalValue == null) {
                return null;
            }
            String stringValue = decimalValue.asDecimal();
            if (stringValue == null) {
                return null;
            }
            return new BigDecimal(stringValue);
        }
        catch (UcumException e) {
            return null;
        }
    }

    @Nullable
    public static String getCanonicalCode(@Nullable BigDecimal value, @Nullable String code) {
        try {
            Pair result = Ucum.getCanonicalForm(value, code);
            if (result == null) {
                return null;
            }
            return result.getCode();
        }
        catch (UcumException e) {
            return null;
        }
    }

    @Nullable
    private static Pair getCanonicalForm(@Nullable BigDecimal value, @Nullable String code) throws UcumException {
        if (value == null || code == null) {
            return null;
        }
        Decimal decimalValue = new Decimal(value.toPlainString());
        return Ucum.adjustNoUnitCode(service.getCanonicalForm(new Pair(decimalValue, code)));
    }

    @Nullable
    private static Pair adjustNoUnitCode(@Nullable Pair pair) {
        if (pair == null) {
            return null;
        }
        return pair.getCode() != null && pair.getCode().isEmpty() ? new Pair(pair.getValue(), NO_UNIT_CODE) : pair;
    }

    static {
        InputStream essenceStream = Ucum.class.getClassLoader().getResourceAsStream("tx/ucum-essence.xml");
        try {
            service = new UcumEssenceService(essenceStream);
        }
        catch (UcumException e) {
            throw new RuntimeException(e);
        }
    }
}

