/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.config;

import au.csiro.pathling.config.HttpClientCachingConfiguration;
import au.csiro.pathling.config.HttpClientConfiguration;
import au.csiro.pathling.config.TerminologyAuthConfiguration;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.URL;

public class TerminologyConfiguration
implements Serializable {
    private static final long serialVersionUID = -5990849769947958140L;
    @NotNull
    private boolean enabled;
    @NotBlank
    @URL
    private String serverUrl;
    @NotNull
    private boolean verboseLogging;
    @NotNull
    @Valid
    private HttpClientConfiguration client;
    @NotNull
    @Valid
    private HttpClientCachingConfiguration cache;
    @NotNull
    @Valid
    private TerminologyAuthConfiguration authentication;

    private static boolean $default$enabled() {
        return true;
    }

    private static String $default$serverUrl() {
        return "https://tx.ontoserver.csiro.au/fhir";
    }

    private static boolean $default$verboseLogging() {
        return false;
    }

    private static HttpClientConfiguration $default$client() {
        return HttpClientConfiguration.builder().build();
    }

    private static HttpClientCachingConfiguration $default$cache() {
        return HttpClientCachingConfiguration.builder().build();
    }

    private static TerminologyAuthConfiguration $default$authentication() {
        return TerminologyAuthConfiguration.builder().build();
    }

    TerminologyConfiguration(boolean enabled, String serverUrl, boolean verboseLogging, HttpClientConfiguration client, HttpClientCachingConfiguration cache, TerminologyAuthConfiguration authentication) {
        this.enabled = enabled;
        this.serverUrl = serverUrl;
        this.verboseLogging = verboseLogging;
        this.client = client;
        this.cache = cache;
        this.authentication = authentication;
    }

    public static TerminologyConfigurationBuilder builder() {
        return new TerminologyConfigurationBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public HttpClientConfiguration getClient() {
        return this.client;
    }

    public HttpClientCachingConfiguration getCache() {
        return this.cache;
    }

    public TerminologyAuthConfiguration getAuthentication() {
        return this.authentication;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    public void setClient(HttpClientConfiguration client) {
        this.client = client;
    }

    public void setCache(HttpClientCachingConfiguration cache) {
        this.cache = cache;
    }

    public void setAuthentication(TerminologyAuthConfiguration authentication) {
        this.authentication = authentication;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TerminologyConfiguration)) {
            return false;
        }
        TerminologyConfiguration other = (TerminologyConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isVerboseLogging() != other.isVerboseLogging()) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        HttpClientConfiguration this$client = this.getClient();
        HttpClientConfiguration other$client = other.getClient();
        if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
            return false;
        }
        HttpClientCachingConfiguration this$cache = this.getCache();
        HttpClientCachingConfiguration other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        TerminologyAuthConfiguration this$authentication = this.getAuthentication();
        TerminologyAuthConfiguration other$authentication = other.getAuthentication();
        return !(this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TerminologyConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isVerboseLogging() ? 79 : 97);
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        HttpClientConfiguration $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        HttpClientCachingConfiguration $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        TerminologyAuthConfiguration $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        return result;
    }

    public String toString() {
        return "TerminologyConfiguration(enabled=" + this.isEnabled() + ", serverUrl=" + this.getServerUrl() + ", verboseLogging=" + this.isVerboseLogging() + ", client=" + this.getClient() + ", cache=" + this.getCache() + ", authentication=" + this.getAuthentication() + ")";
    }

    public static class TerminologyConfigurationBuilder {
        private boolean enabled$set;
        private boolean enabled$value;
        private boolean serverUrl$set;
        private String serverUrl$value;
        private boolean verboseLogging$set;
        private boolean verboseLogging$value;
        private boolean client$set;
        private HttpClientConfiguration client$value;
        private boolean cache$set;
        private HttpClientCachingConfiguration cache$value;
        private boolean authentication$set;
        private TerminologyAuthConfiguration authentication$value;

        TerminologyConfigurationBuilder() {
        }

        public TerminologyConfigurationBuilder enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        public TerminologyConfigurationBuilder serverUrl(String serverUrl) {
            this.serverUrl$value = serverUrl;
            this.serverUrl$set = true;
            return this;
        }

        public TerminologyConfigurationBuilder verboseLogging(boolean verboseLogging) {
            this.verboseLogging$value = verboseLogging;
            this.verboseLogging$set = true;
            return this;
        }

        public TerminologyConfigurationBuilder client(HttpClientConfiguration client) {
            this.client$value = client;
            this.client$set = true;
            return this;
        }

        public TerminologyConfigurationBuilder cache(HttpClientCachingConfiguration cache) {
            this.cache$value = cache;
            this.cache$set = true;
            return this;
        }

        public TerminologyConfigurationBuilder authentication(TerminologyAuthConfiguration authentication) {
            this.authentication$value = authentication;
            this.authentication$set = true;
            return this;
        }

        public TerminologyConfiguration build() {
            boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = TerminologyConfiguration.$default$enabled();
            }
            String serverUrl$value = this.serverUrl$value;
            if (!this.serverUrl$set) {
                serverUrl$value = TerminologyConfiguration.$default$serverUrl();
            }
            boolean verboseLogging$value = this.verboseLogging$value;
            if (!this.verboseLogging$set) {
                verboseLogging$value = TerminologyConfiguration.$default$verboseLogging();
            }
            HttpClientConfiguration client$value = this.client$value;
            if (!this.client$set) {
                client$value = TerminologyConfiguration.$default$client();
            }
            HttpClientCachingConfiguration cache$value = this.cache$value;
            if (!this.cache$set) {
                cache$value = TerminologyConfiguration.$default$cache();
            }
            TerminologyAuthConfiguration authentication$value = this.authentication$value;
            if (!this.authentication$set) {
                authentication$value = TerminologyConfiguration.$default$authentication();
            }
            return new TerminologyConfiguration(enabled$value, serverUrl$value, verboseLogging$value, client$value, cache$value, authentication$value);
        }

        public String toString() {
            return "TerminologyConfiguration.TerminologyConfigurationBuilder(enabled$value=" + this.enabled$value + ", serverUrl$value=" + this.serverUrl$value + ", verboseLogging$value=" + this.verboseLogging$value + ", client$value=" + this.client$value + ", cache$value=" + this.cache$value + ", authentication$value=" + this.authentication$value + ")";
        }
    }
}

