# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['datayoga']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'click>=8.0.3,<9.0.0',
 'datayoga-core>=1.0.0,<2.0.0',
 'jsonschema>=4.4.0,<5.0.0']

extras_require = \
{'test': ['mock>=4.0.3,<5.0.0',
          'pytest>=7.1.2,<8.0.0',
          'pytest-describe>=2.0.1,<3.0.0',
          'pytest-mock>=3.7.0,<4.0.0',
          'pytest-timeout>=2.1.0,<3.0.0',
          'requests-mock>=1.9.3,<2.0.0']}

entry_points = \
{'console_scripts': ['datayoga = datayoga.__main__:main']}

setup_kwargs = {
    'name': 'datayoga',
    'version': '1.3.0',
    'description': 'DataYoga command line interface',
    'long_description': '# DataYoga CLI\n\n## Development\n\nTo set up environment in development mode:\n\n### Set Up Virtual Environment\n\n```bash\npython -m venv venv\nsource venv/bin/activate\n```\n\n### Upgrade `pip` to Latest Version\n\n> [Pip](https://pypi.org/project/pip) version 22 and up is needed for editable install.\n\n```bash\npython -m pip install --upgrade pip\n```\n\n### Install Dependencies\n\n```bash\ncd core\npython -m pip install -e .\n```\n\n## Run CLI in Development Mode\n\n```bash\npython ./cli/src/datayoga/__main__.py\n```\n',
    'author': 'DataYoga',
    'author_email': 'admin@datayoga.io',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
