import { IFunction } from '@aws-cdk/aws-lambda';
import { IQueue } from '@aws-cdk/aws-sqs';
import { IStateMachine } from '@aws-cdk/aws-stepfunctions';
import { Construct } from '@aws-cdk/core';
import { DenyList } from '../deny-list';
import { TransliteratorProps } from '../transliterator';
export interface OrchestrationProps extends Omit<TransliteratorProps, 'efsAccessPoint' | 'language'> {
    /**
     * The deny list.
     */
    readonly denyList: DenyList;
}
/**
 * Orchestrates the backend processing tasks using a StepFunctions State Machine.
 */
export declare class Orchestration extends Construct {
    /**
     * The state machine that should be triggered for starting back-end processing
     * for a newly discovered package.
     */
    readonly stateMachine: IStateMachine;
    /**
     * The dead letter queue from the state machine. Inputs and errors are written
     * there if the state machine fails.
     */
    readonly deadLetterQueue: IQueue;
    /**
     * The function operators can use to redrive messages from the dead letter
     * queue.
     */
    readonly redriveFunction: IFunction;
    /**
     * The function operators can use to reprocess all indexed packages through
     * the backend data pipeline.
     */
    readonly reprocessAllFunction: IFunction;
    /**
     * The function that builds the catalog.
     */
    readonly catalogBuilder: IFunction;
    constructor(scope: Construct, id: string, props: OrchestrationProps);
    private newEfsAccessPoint;
}
