import { Alarm, Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { IFunction } from '@aws-cdk/aws-lambda';
import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { IQueue } from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
import { DenyList } from '../deny-list';
export interface DiscoveryProps {
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
    /**
     * The queue to post package updated messages to
     */
    readonly queue: IQueue;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
    /**
     * The deny list construct.
     */
    readonly denyList: DenyList;
}
/**
 * This discovery function periodically scans the CouchDB replica of npmjs.com
 * to discover newly published packages that are relevant for indexing in the
 * Construct Hub, then notifies the ingestion function about those.
 */
export declare class Discovery extends Construct {
    /**
     * The S3 bucket in which the discovery function stages npm packages.
     */
    readonly bucket: IBucket;
    /**
     * Alarms if the discovery function does not complete successfully.
     */
    readonly alarmErrors: Alarm;
    /**
     * Alarms if the discovery function does not run as expected.
     */
    readonly alarmNoInvocations: Alarm;
    readonly function: IFunction;
    private readonly timeout;
    constructor(scope: Construct, id: string, props: DiscoveryProps);
    /**
     * The average time it took to process a changes batch.
     */
    metricBatchProcessingTime(opts?: MetricOptions): Metric;
    /**
     * The total count of changes that were processed.
     */
    metricChangeCount(opts?: MetricOptions): Metric;
    metricNpmJsChangeAge(opts?: MetricOptions): Metric;
    /**
     * The age of the oldest package version that was processed.
     */
    metricPackageVersionAge(opts?: MetricOptions): Metric;
    /**
     * The total count of package versions that were inspected.
     */
    metricPackageVersionCount(opts?: MetricOptions): Metric;
    /**
     * The total count of package versions that were deemed relevant.
     */
    metricRelevantPackageVersions(opts?: MetricOptions): Metric;
    /**
     * The amount of time that was remaining when the lambda returned in order to
     * avoid hitting a timeout.
     */
    metricRemainingTime(opts?: MetricOptions): Metric;
    /**
     * The total count of staging failures.
     */
    metricStagingFailureCount(opts?: MetricOptions): Metric;
    /**
     * The average time it took to stage a package to S3.
     */
    metricStagingTime(opts?: MetricOptions): Metric;
    /**
     * The amount of changes that were not processed due to having an invalid
     * format.
     */
    metricUnprocessableEntity(opts?: MetricOptions): Metric;
}
