"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeSettings = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * VS Code Workspace settings
 * Source: https://code.visualstudio.com/docs/getstarted/settings#_workspace-settings
 */
class VsCodeSettings extends component_1.Component {
    constructor(vscode) {
        super(vscode.project);
        this.content = {};
        new json_1.JsonFile(vscode.project, ".vscode/settings.json", {
            omitEmpty: false,
            obj: this.content,
        });
    }
    /**
     * Adds a workspace setting
     *
     * @param setting The setting ID
     * @param value The value of the setting
     * @param language Scope the setting to a specific language
     */
    addSetting(setting, value, language) {
        if (language) {
            this.content[`[${language}]`] = this.content[`[${language}]`] ?? {};
            this.content[`[${language}]`][setting] = value;
        }
        else {
            this.content[setting] = value;
        }
    }
    /**
     * Adds a workspace setting
     *
     * @param settings Array structure: [setting: string, value: any, languages?: string[]]
     */
    addSettings(settings, languages) {
        if (Array.isArray(languages)) {
            languages.forEach((language) => {
                Object.entries(settings).forEach(([setting, value]) => this.addSetting(setting, value, language));
            });
        }
        else {
            Object.entries(settings).forEach(([setting, value]) => this.addSetting(setting, value, languages));
        }
    }
}
exports.VsCodeSettings = VsCodeSettings;
_a = JSII_RTTI_SYMBOL_1;
VsCodeSettings[_a] = { fqn: "projen.vscode.VsCodeSettings", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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