"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeLaunchConfig = exports.InternalConsoleOptions = exports.Console = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Controls where to launch the debug target
 * Source: https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes
 */
var Console;
(function (Console) {
    Console["INTERNAL_CONSOLE"] = "internalConsole";
    Console["INTEGRATED_TERMINAL"] = "integratedTerminal";
    Console["EXTERNAL_TERMINAL"] = "externalTerminal";
})(Console = exports.Console || (exports.Console = {}));
/**
 * Controls the visibility of the VSCode Debug Console panel during a debugging session
 * Source: https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes
 */
var InternalConsoleOptions;
(function (InternalConsoleOptions) {
    InternalConsoleOptions["NEVER_OPEN"] = "neverOpen";
    InternalConsoleOptions["OPEN_ON_FIRST_SESSION_START"] = "openOnFirstSessionStart";
    InternalConsoleOptions["OPEN_ON_SESSION_START"] = "openOnSessionStart";
})(InternalConsoleOptions = exports.InternalConsoleOptions || (exports.InternalConsoleOptions = {}));
/**
 * VSCode launch configuration file (launch.json), useful for enabling in-editor debugger
 */
class VsCodeLaunchConfig extends component_1.Component {
    constructor(vscode) {
        super(vscode.project);
        this.content = {
            version: "0.2.0",
            configurations: [],
        };
        new json_1.JsonFile(vscode.project, ".vscode/launch.json", {
            obj: () => ({
                ...this.content,
                configurations: this.content.configurations.map(VsCodeLaunchConfig.renderLaunchConfig),
            }),
        });
    }
    static renderLaunchConfig(cfg) {
        if (!cfg.env) {
            return cfg;
        }
        return {
            ...cfg,
            env: Object.fromEntries(Object.entries(cfg.env).map(([key, value]) => [
                key,
                value === false ? null : value,
            ])),
        };
    }
    /**
     * Adds a VsCodeLaunchConfigurationEntry (e.g. a node.js debugger) to `.vscode/launch.json.
     * Each configuration entry has following mandatory fields: type, request and name.
     * See https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes for details.
     * @param cfg VsCodeLaunchConfigurationEntry
     */
    addConfiguration(cfg) {
        this.content.configurations.push(cfg);
    }
}
exports.VsCodeLaunchConfig = VsCodeLaunchConfig;
_a = JSII_RTTI_SYMBOL_1;
VsCodeLaunchConfig[_a] = { fqn: "projen.vscode.VsCodeLaunchConfig", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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