"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Renovatebot = exports.RenovatebotScheduleInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const dependencies_1 = require("./dependencies");
const json_1 = require("./json");
/**
 * How often to check for new versions and raise pull requests for version
 * updates.
 *
 * @see https://docs.renovatebot.com/presets-schedule/
 */
var RenovatebotScheduleInterval;
(function (RenovatebotScheduleInterval) {
    /**
     * Run at any time
     */
    RenovatebotScheduleInterval["ANY_TIME"] = "at any time";
    /**
     * Weekly schedule on early monday mornings
     */
    RenovatebotScheduleInterval["EARLY_MONDAYS"] = "before 3am on Monday";
    /**
     * Schedule daily
     */
    RenovatebotScheduleInterval["DAILY"] = "before 2am";
    /**
     * Schedule weekly
     */
    RenovatebotScheduleInterval["WEEKLY"] = "before 3am on Monday";
    /**
     * Schedule monthly
     */
    RenovatebotScheduleInterval["MONTHLY"] = "before 3am on the first day of the month";
    /**
     * Schedule quarterly
     */
    RenovatebotScheduleInterval["QUARTERLY"] = "every 3 months on the first day of the month";
    /**
     * Schedule for weekends
     */
    RenovatebotScheduleInterval["WEEKENDS"] = "every weekend";
    /**
     * Schedule for weekdays
     */
    RenovatebotScheduleInterval["WEEKDAYS"] = "every weekday";
})(RenovatebotScheduleInterval = exports.RenovatebotScheduleInterval || (exports.RenovatebotScheduleInterval = {}));
/**
 * Defines renovatebot configuration for projen project.
 *
 * Ignores the versions controlled by Projen.
 */
class Renovatebot extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this._project = project;
        this.explicitIgnores = options.ignore ?? [];
        this.labels = options.labels;
        this.scheduleInterval = options.scheduleInterval ?? [
            RenovatebotScheduleInterval.ANY_TIME,
        ];
        (options.ignoreProjen ?? true) && this.explicitIgnores.push("projen");
        this.overrideConfig = options.overrideConfig ?? {};
        this.marker = options.marker ?? true;
    }
    // create actual file only here, so we know that all dependencies are added to the project
    preSynthesize() {
        this.createRenovateConfiguration();
    }
    createRenovateConfiguration() {
        const renovateIgnore = [
            ...new Set(this._project.deps.all
                .filter((dep) => dep.version || dep.type === dependencies_1.DependencyType.OVERRIDE)
                .map((dep) => dep.name)
                .concat(this.explicitIgnores)),
        ];
        const config = {
            labels: this.labels,
            schedule: this.scheduleInterval,
            extends: [
                ":preserveSemverRanges",
                "config:base",
                "group:allNonMajor",
                "group:recommended",
                "group:monorepos",
            ],
            packageRules: [
                {
                    matchDepTypes: ["devDependencies"],
                    matchUpdateTypes: ["patch", "minor"],
                    groupName: "devDependencies (non-major)",
                },
            ],
            ignoreDeps: renovateIgnore,
            ...this.overrideConfig,
        };
        new json_1.JsonFile(this._project, "renovate.json5", {
            obj: config,
            committed: true,
            marker: this.marker,
        });
    }
}
exports.Renovatebot = Renovatebot;
_a = JSII_RTTI_SYMBOL_1;
Renovatebot[_a] = { fqn: "projen.Renovatebot", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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