"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetupPy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("../file");
/**
 * Python packaging script where package metadata can be placed.
 */
class SetupPy extends file_1.FileBase {
    constructor(project, options) {
        super(project, "setup.py");
        this.setupConfig = {
            name: project.name,
            packages: options.packages,
            python_requires: ">=3.7",
            classifiers: [
                "Intended Audience :: Developers",
                "Programming Language :: Python :: 3 :: Only",
                "Programming Language :: Python :: 3.7",
                "Programming Language :: Python :: 3.8",
                "Programming Language :: Python :: 3.9",
                "Programming Language :: Python :: 3.10",
            ],
            ...(options ? this.renameFields(options) : []),
        };
    }
    synthesizeContent(resolver) {
        const lines = [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            "import json",
            "from setuptools import setup",
            "",
            "kwargs = json.loads(",
            '    """',
            JSON.stringify(this.setupConfig, null, 4),
            '"""',
            ")",
            "",
            "setup(**kwargs)",
        ];
        return `${resolver.resolve(lines).join("\n")}\n`;
    }
    // modify some key names since JSII interfaces require fields to be camelCase
    renameFields(options) {
        const obj = {};
        for (const [key, value] of Object.entries(options)) {
            if (key === "authorName") {
                obj.author = value;
            }
            else if (key === "authorEmail") {
                obj.author_email = value;
            }
            else if (key === "homepage") {
                obj.url = value;
            }
            else {
                obj[key] = value;
            }
        }
        return obj;
    }
}
exports.SetupPy = SetupPy;
_a = JSII_RTTI_SYMBOL_1;
SetupPy[_a] = { fqn: "projen.python.SetupPy", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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