"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pytest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
class Pytest extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        const version = options.version ?? "6.2.1";
        this.testdir = options.testdir ?? "tests";
        project.deps.addDependency(`pytest@${version}`, dependencies_1.DependencyType.TEST);
        project.testTask.exec([
            "pytest",
            ...(options.maxFailures ? [`--maxfail=${options.maxFailures}`] : []),
        ].join(" "));
    }
}
exports.Pytest = Pytest;
_a = JSII_RTTI_SYMBOL_1;
Pytest[_a] = { fqn: "projen.python.Pytest", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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