"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptConfig = exports.TypeScriptJsxMode = exports.TypeScriptModuleResolution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const json_1 = require("../json");
/**
 * Determines how modules get resolved.
 *
 * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html
 */
var TypeScriptModuleResolution;
(function (TypeScriptModuleResolution) {
    /**
     * TypeScript's former default resolution strategy.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#classic
     */
    TypeScriptModuleResolution["CLASSIC"] = "classic";
    /**
     * Resolution strategy which attempts to mimic the Node.js module resolution strategy at runtime.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#node
     */
    TypeScriptModuleResolution["NODE"] = "node";
    /**
     * Node.js’ ECMAScript Module Support from TypeScript 4.7 onwards
     *
     * @see https://www.typescriptlang.org/tsconfig#moduleResolution
     */
    TypeScriptModuleResolution["NODE16"] = "node16";
    /**
     * Node.js’ ECMAScript Module Support from TypeScript 4.7 onwards
     *
     * @see https://www.typescriptlang.org/tsconfig#moduleResolution
     */
    TypeScriptModuleResolution["NODE_NEXT"] = "nodenext";
})(TypeScriptModuleResolution = exports.TypeScriptModuleResolution || (exports.TypeScriptModuleResolution = {}));
/**
 * Determines how JSX should get transformed into valid JavaScript.
 *
 * @see https://www.typescriptlang.org/docs/handbook/jsx.html
 */
var TypeScriptJsxMode;
(function (TypeScriptJsxMode) {
    /**
     * Keeps the JSX as part of the output to be further consumed by another transform step (e.g. Babel).
     */
    TypeScriptJsxMode["PRESERVE"] = "preserve";
    /**
     * Converts JSX syntax into React.createElement, does not need to go through a JSX transformation before use, and the output will have a .js file extension.
     */
    TypeScriptJsxMode["REACT"] = "react";
    /**
     * Keeps all JSX like 'preserve' mode, but output will have a .js extension.
     */
    TypeScriptJsxMode["REACT_NATIVE"] = "react-native";
    /**
     * Passes `key` separately from props and always passes `children` as props (since React 17).
     *
     * @see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-4-1.html#react-17-jsx-factories
     */
    TypeScriptJsxMode["REACT_JSX"] = "react-jsx";
    /**
     * Same as `REACT_JSX` with additional debug data.
     */
    TypeScriptJsxMode["REACT_JSXDEV"] = "react-jsxdev";
})(TypeScriptJsxMode = exports.TypeScriptJsxMode || (exports.TypeScriptJsxMode = {}));
class TypescriptConfig {
    constructor(project, options) {
        const fileName = options.fileName ?? "tsconfig.json";
        this.include = options.include ?? ["**/*.ts"];
        this.exclude = options.exclude ?? ["node_modules"];
        this.fileName = fileName;
        this.compilerOptions = options.compilerOptions;
        this.file = new json_1.JsonFile(project, fileName, {
            obj: {
                compilerOptions: this.compilerOptions,
                include: () => this.include,
                exclude: () => this.exclude,
            },
        });
        project.npmignore?.exclude(`/${fileName}`);
    }
    addInclude(pattern) {
        this.include.push(pattern);
    }
    addExclude(pattern) {
        this.exclude.push(pattern);
    }
}
exports.TypescriptConfig = TypescriptConfig;
_a = JSII_RTTI_SYMBOL_1;
TypescriptConfig[_a] = { fqn: "projen.javascript.TypescriptConfig", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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