"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stale = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stale_util_1 = require("./stale-util");
const workflows_model_1 = require("./workflows-model");
const component_1 = require("../component");
/**
 * Warns and then closes issues and PRs that have had no activity for a specified amount of time.
 *
 * The default configuration will:
 *
 *  * Add a "Stale" label to pull requests after 14 days and closed after 2 days
 *  * Add a "Stale" label to issues after 60 days and closed after 7 days
 *  * If a comment is added, the label will be removed and timer is restarted.
 *
 * @see https://github.com/actions/stale
 */
class Stale extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        const stale = github.addWorkflow("stale");
        stale.on({
            schedule: [{ cron: "0 1 * * *" }],
            workflowDispatch: {},
        });
        const pullRequests = stale_util_1.renderBehavior(options.pullRequest, {
            stale: 14,
            close: 2,
            type: "pull request",
        });
        const issues = stale_util_1.renderBehavior(options.issues, {
            stale: 60,
            close: 7,
            type: "issue",
        });
        const renderExemptLabels = (exemptLabels) => {
            if (!exemptLabels || exemptLabels.length === 0) {
                return undefined;
            }
            return exemptLabels.join(",");
        };
        stale.addJobs({
            stale: {
                runsOn: options.runsOn ?? ["ubuntu-latest"],
                permissions: {
                    issues: workflows_model_1.JobPermission.WRITE,
                    pullRequests: workflows_model_1.JobPermission.WRITE,
                },
                steps: [
                    {
                        uses: "actions/stale@v4",
                        with: {
                            // disable global
                            "days-before-stale": -1,
                            "days-before-close": -1,
                            // pull requests
                            "days-before-pr-stale": pullRequests.daysBeforeStale,
                            "days-before-pr-close": pullRequests.daysBeforeClose,
                            "stale-pr-message": pullRequests.staleMessage,
                            "close-pr-message": pullRequests.closeMessage,
                            "stale-pr-label": pullRequests.staleLabel,
                            "exempt-pr-labels": renderExemptLabels(pullRequests.exemptLabels),
                            // issues
                            "days-before-issue-stale": issues.daysBeforeStale,
                            "days-before-issue-close": issues.daysBeforeClose,
                            "stale-issue-message": issues.staleMessage,
                            "close-issue-message": issues.closeMessage,
                            "stale-issue-label": issues.staleLabel,
                            "exempt-issue-labels": renderExemptLabels(issues.exemptLabels),
                        },
                    },
                ],
            },
        });
    }
}
exports.Stale = Stale;
_a = JSII_RTTI_SYMBOL_1;
Stale[_a] = { fqn: "projen.github.Stale", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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