"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mergify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const yaml_1 = require("../yaml");
class Mergify extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        this.rules = new Array();
        this.queues = new Array();
        for (const rule of options.rules ?? []) {
            this.addRule(rule);
        }
        for (const queue of options.queues ?? []) {
            this.addQueue(queue);
        }
    }
    createYamlFile() {
        if (this.yamlFile == null) {
            this.yamlFile = new yaml_1.YamlFile(this.project, ".mergify.yml", {
                obj: {
                    queue_rules: this.queues,
                    pull_request_rules: this.rules,
                },
                // Mergify needs to read the file from the repository in order to work.
                committed: true,
            });
        }
    }
    addRule(rule) {
        this.rules.push(rule);
        this.createYamlFile();
    }
    addQueue(queue) {
        this.queues.push(queue);
        this.createYamlFile();
    }
}
exports.Mergify = Mergify;
_a = JSII_RTTI_SYMBOL_1;
Mergify[_a] = { fqn: "projen.github.Mergify", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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