"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitAttributesFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * Assign attributes to file names in a git repository.
 *
 * @see https://git-scm.com/docs/gitattributes
 */
class GitAttributesFile extends file_1.FileBase {
    constructor(project) {
        super(project, ".gitattributes", {
            editGitignore: false,
        });
        this.attributes = new Map();
    }
    /**
     * Maps a set of attributes to a set of files.
     * @param glob Glob pattern to match files in the repo
     * @param attributes Attributes to assign to these files.
     */
    addAttributes(glob, ...attributes) {
        if (!this.attributes.has(glob)) {
            this.attributes.set(glob, new Set());
        }
        const set = this.attributes.get(glob);
        for (const attribute of attributes) {
            set.add(attribute);
        }
    }
    synthesizeContent(_) {
        // We can assume the file map is never empty.
        const entries = Array.from(this.attributes.entries()).sort(([l], [r]) => l.localeCompare(r));
        if (entries.length === 0) {
            return undefined;
        }
        return [
            ...(this.marker ? [`# ${this.marker}`] : []),
            "",
            ...entries.map(([name, attributes]) => `${name} ${Array.from(attributes).join(" ")}`),
        ].join("\n");
    }
}
exports.GitAttributesFile = GitAttributesFile;
_a = JSII_RTTI_SYMBOL_1;
GitAttributesFile[_a] = { fqn: "projen.GitAttributesFile", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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