"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestAutoDiscover = exports.AutoDiscover = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_test_1 = require("./integration-test");
const cdk_1 = require("../cdk");
const component_1 = require("../component");
/**
 * Automatically discovers and creates `IntegrationTest`s from entry points
 * found in the test tree.
 */
class AutoDiscover extends component_1.Component {
    constructor(project, options) {
        super(project);
        if (options.integrationTestAutoDiscover ?? true) {
            new IntegrationTestAutoDiscover(this.project, options);
        }
    }
}
exports.AutoDiscover = AutoDiscover;
_a = JSII_RTTI_SYMBOL_1;
AutoDiscover[_a] = { fqn: "projen.cdk8s.AutoDiscover", version: "0.67.21" };
/**
 * Discovers and creates integration tests from files in the test root.
 */
class IntegrationTestAutoDiscover extends cdk_1.IntegrationTestAutoDiscoverBase {
    constructor(project, options) {
        super(project, options);
        for (const entrypoint of this.entrypoints) {
            new integration_test_1.IntegrationTest(this.project, {
                entrypoint,
                tsconfigPath: options.tsconfigPath,
            });
        }
    }
}
exports.IntegrationTestAutoDiscover = IntegrationTestAutoDiscover;
_b = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscover[_b] = { fqn: "projen.cdk8s.IntegrationTestAutoDiscover", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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