"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestAutoDiscoverBase = exports.AutoDiscoverBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const glob = require("glob");
const internal_1 = require("./internal");
const component_1 = require("../component");
/**
 * Base class for auto-discovering and creating project subcomponents.
 */
class AutoDiscoverBase extends component_1.Component {
    constructor(project, options) {
        super(project);
        const cwd = path.posix.join(this.project.outdir, options.projectdir);
        this.entrypoints = glob
            .sync(`**/*${options.extension}`, { cwd })
            .map((p) => path.posix.join(options.projectdir, p));
    }
}
exports.AutoDiscoverBase = AutoDiscoverBase;
_a = JSII_RTTI_SYMBOL_1;
AutoDiscoverBase[_a] = { fqn: "projen.cdk.AutoDiscoverBase", version: "0.67.21" };
/**
 * Base class for locating integration tests in the project's test tree.
 */
class IntegrationTestAutoDiscoverBase extends AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            extension: internal_1.TYPESCRIPT_INTEG_EXT,
            projectdir: options.testdir,
        });
    }
}
exports.IntegrationTestAutoDiscoverBase = IntegrationTestAutoDiscoverBase;
_b = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscoverBase[_b] = { fqn: "projen.cdk.IntegrationTestAutoDiscoverBase", version: "0.67.21" };
//# sourceMappingURL=data:application/json;base64,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