# Generated by Django 2.2.13 on 2020-12-10 22:06

from django.conf import settings
from django.db import migrations, models
import django.utils.timezone

from NEMO.migrations_utils import create_news_for_version


class Migration(migrations.Migration):

    dependencies = [
        ('NEMO', '0025_version_3_6_0'),
    ]

    def new_version_news(apps, schema_editor):
        create_news_for_version(apps, "3.7.0", "")

    operations = [
        migrations.CreateModel(
            name='BuddyRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('creation_time', models.DateTimeField(default=django.utils.timezone.now, help_text='The date and time when the request was created.')),
                ('start', models.DateField(help_text='The start date the user is requesting a buddy.')),
                ('end', models.DateField(help_text='The end date the user is requesting a buddy.')),
                ('description', models.TextField(help_text='The description of the request.')),
                ('expired', models.BooleanField(default=False, help_text="Indicates the request has expired and won't be shown anymore.")),
                ('deleted', models.BooleanField(default=False, help_text="Indicates the request has been deleted and won't be shown anymore.")),
                ('area', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='NEMO.Area')),
                ('user', models.ForeignKey(help_text='The user who is submitting the request.', on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='area',
            name='buddy_system_allowed',
            field=models.BooleanField(default=False, help_text='Check this box if the buddy system is allowed in this area.'),
        ),
        migrations.AddField(
            model_name='userpreferences',
            name='display_new_buddy_request_notification',
            field=models.BooleanField(default=True, help_text='Whether or not to notify the user of new buddy requests (via unread badges)', verbose_name='new_buddy_request_notification'),
        ),
        migrations.AddField(
            model_name='userpreferences',
            name='display_new_buddy_request_reply_notification',
            field=models.BooleanField(default=True, help_text='Whether or not to notify the user of replies on buddy request he commented on (via unread badges)', verbose_name='new_buddy_request_reply_notification'),
        ),
        migrations.AddField(
            model_name='userpreferences',
            name='email_new_buddy_request_reply',
            field=models.BooleanField(default=True, help_text='Whether or not to email the user of replies on buddy request he commented on', verbose_name='email_new_buddy_request_reply'),
        ),
        migrations.AlterField(
            model_name='landingpagechoice',
            name='notifications',
            field=models.CharField(blank=True, choices=[('news', 'News creation and updates - notifies all users'), ('safetyissue', 'New safety issues - notifies staff only'), ('buddyrequest', 'New buddy request - notifies all users'), ('buddyrequestmessage', 'New buddy request reply - notifies request creator and users who have replied')], help_text="Displays a the number of new notifications for the user. For example, if the user has two unread news notifications then the number '2' would appear for the news icon on the landing page.", max_length=25, null=True),
        ),
        migrations.CreateModel(
            name='BuddyRequestMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('creation_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('content', models.TextField()),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('buddy_request', models.ForeignKey(help_text='The request that this message relates to.', on_delete=django.db.models.deletion.CASCADE, related_name='replies', to='NEMO.BuddyRequest')),
            ],
            options={
                'ordering': ['creation_date'],
            },
        ),
        migrations.CreateModel(
            name='EmailLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.IntegerField(choices=[(0, 'General'), (1, 'System'), (2, 'Direct Contact'), (3, 'Broadcast Email'), (4, 'Timed Services'), (5, 'Feedback'), (6, 'Abuse'), (7, 'Safety'), (8, 'Tasks')], default=0)),
                ('when', models.DateTimeField(auto_now_add=True)),
                ('sender', models.EmailField(max_length=254)),
                ('to', models.TextField()),
                ('subject', models.CharField(max_length=254)),
                ('content', models.TextField()),
                ('ok', models.BooleanField(default=True)),
                ('attachments', models.TextField(null=True)),
            ],
            options={
                'ordering': ['-when'],
            },
        ),
        migrations.RunPython(new_version_news),
    ]
