# retrotype

Tools for typing-in, debugging, and converting 1980s magazine type-in games and
programs for use with Commodore emulators and original hardware.

## Installation (requires Python 3.8 or later)

`pip3 install retrotype --upgrade`

## Tool: retrotype_cli

The `retrotype_cli` tool is a command line debugger and converter for Commodore
BASIC programs focused on tokenizing magazine type-in programs popular in the
1980s. Given an input text file containing BASIC source code in magazine
type-in format, it checks the typed line entries against line checksums that
were printed in the magazines to insure program is bug-free. It outputs both
the checksums to the terminal and writes a file with the extension '.chk' for
comparison with the checksums printed in the magazine or with a '.ref' file
containing the line numbers and checksums from the magazine. Finally, it
outputs an executable '.prg' file for direct use with an emulator or original
hardware.

### Usage

After installation, use `retrotype_cli` directly from the command line -
consult the help for the latest usage:

**Note:** Currently the only implemented options are for Ahoy C64 programs.

```
retrotype_cli [-l load_address] [-s source_format] input_file
```

```
positional arguments:
  input_file            Specify the input file name, including path.
                        Note:  Output files will use input file basename

optional arguments:
  -h, --help            show this help message and exit

  -l load_address, --loadaddr load_address
                        Specifies the target BASIC memory address when loading:
                        - 0x0801 - C64 (default)
                        - 0x1001 - VIC20 Unexpanded
                        - 0x0401 - VIC20 +3K
                        - 0x1201 - VIC20 +8K
                        - 0x1201 - VIC20 +16
                        - 0x1201 - VIC20 +24K

  -s source_format, --source source_format
                        Specifies the magazine source for conversion and checksum:
                        ahoy1 - Ahoy magazine (Apr-May 1984)
                        ahoy2 - Ahoy magazine (Jun 1984-Apr 1987) (default)
                        ahoy3 - Ahoy magazine (May 1987-)
```

As an example for an Ahoy! magazine file:

```
Input:  basename.bas

Outputs:  basename.prg (tokenized file that can be run on a Commodore computer
                        or on an emulator like VICE)
          basename.chk (list of line numbers and checksums, along with the
                        number of lines, for comparision to checksums printed
                        in the magazine)
```

### Notes for entering programs from Ahoy issues prior to November 1984:

In addition to the special character codes contained in braces
in the magazine, Ahoy also used a shorthand convention for
specifying a key entry preceeded by either the Shift key or the
Commodore key as follows:

    Underlined characters - preceed entry with Shift key
    Overlined characters - preceed entry with Commodore key

Standard keyboard letters should be typed as follows for these two cases.

    {s A}, {s B}, {s *} etc.
    {c A}, {c B}, {c *}, etc.

There are a few instances where the old hardware has keys not
available on a modern keyboard or are otherwise ambiguous.
Those should be entered as follows:

    {EP} - British Pound symbol
    {UP_ARROW} - up arrow symbol
    {LEFT_ARROW} - left arrow symbol
    {PI} - Pi symbol
    {s RETURN} - shifted return
    {s SPACE} - shifted space
    {c EP} - Commodore-Bristish Pound symbol
    {s UP_ARROW} - shifted up arrow symbol

After the October 1984 issue, the over/under score representation was
discontinued as was the use of braces as delineators. After October 1984, the
braces were replaced by brackets, however, either can be used while typing in
the programs for any issue. The special characters can be typed as listed
in the magazines after that issue.

### Using the output files

You can run the .prg file generated by the `retrotype_cli` program by
running it with the VICE emulator with the following command (must have VICE
installed):

```
x64sc -basicload program_name.prg &
```

Of course, you can also run the .prg file on original hardware.
