"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dependable = exports.DependencyGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A set of constructs to be used as a dependable
 *
 * This class can be used when a set of constructs which are disjoint in the
 * construct tree needs to be combined to be used as a single dependable.
 *
 * @experimental
 */
class DependencyGroup {
    constructor(...deps) {
        this._deps = new Array();
        const self = this;
        Dependable.implement(this, {
            get dependencyRoots() {
                const result = new Array();
                for (const d of self._deps) {
                    result.push(...Dependable.of(d).dependencyRoots);
                }
                return result;
            },
        });
        this.add(...deps);
    }
    /**
     * Add a construct to the dependency roots
     */
    add(...scopes) {
        this._deps.push(...scopes);
    }
}
exports.DependencyGroup = DependencyGroup;
_a = JSII_RTTI_SYMBOL_1;
DependencyGroup[_a] = { fqn: "constructs.DependencyGroup", version: "10.1.12" };
const DEPENDABLE_SYMBOL = Symbol.for('@aws-cdk/core.DependableTrait');
/**
 * Trait for IDependable
 *
 * Traits are interfaces that are privately implemented by objects. Instead of
 * showing up in the public interface of a class, they need to be queried
 * explicitly. This is used to implement certain framework features that are
 * not intended to be used by Construct consumers, and so should be hidden
 * from accidental use.
 *
 * @example
 *
 * // Usage
 * const roots = DependableTrait.get(construct).dependencyRoots;
 *
 * // Definition
 * DependableTrait.implement(construct, {
 *   get dependencyRoots() { return []; }
 * });
 *
 * @experimental
 */
class Dependable {
    /**
     * Turn any object into an IDependable.
     */
    static implement(instance, trait) {
        // I would also like to reference classes (to cut down on the list of objects
        // we need to manage), but we can't do that either since jsii doesn't have the
        // concept of a class reference.
        instance[DEPENDABLE_SYMBOL] = trait;
    }
    /**
     * Return the matching Dependable for the given class instance.
     */
    static of(instance) {
        const ret = instance[DEPENDABLE_SYMBOL];
        if (!ret) {
            throw new Error(`${instance} does not implement IDependable. Use "Dependable.implement()" to implement`);
        }
        return ret;
    }
    /**
     * Return the matching Dependable for the given class instance.
     * @deprecated use `of`
     */
    static get(instance) {
        return this.of(instance);
    }
}
exports.Dependable = Dependable;
_b = JSII_RTTI_SYMBOL_1;
Dependable[_b] = { fqn: "constructs.Dependable", version: "10.1.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwZW5kZW5jeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kZXBlbmRlbmN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBaUJBOzs7Ozs7O0dBT0c7QUFDSCxNQUFhLGVBQWU7SUFHMUIsWUFBWSxHQUFHLElBQW1CO1FBRmpCLFVBQUssR0FBRyxJQUFJLEtBQUssRUFBZSxDQUFDO1FBR2hELE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQztRQUVsQixVQUFVLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRTtZQUN6QixJQUFJLGVBQWU7Z0JBQ2pCLE1BQU0sTUFBTSxHQUFHLElBQUksS0FBSyxFQUFjLENBQUM7Z0JBQ3ZDLEtBQUssTUFBTSxDQUFDLElBQUksSUFBSSxDQUFDLEtBQUssRUFBRTtvQkFDMUIsTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLFVBQVUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLENBQUM7aUJBQ2xEO2dCQUNELE9BQU8sTUFBTSxDQUFDO1lBQ2hCLENBQUM7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsSUFBSSxDQUFDLENBQUM7SUFDcEIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksR0FBRyxDQUFDLEdBQUcsTUFBcUI7UUFDakMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxNQUFNLENBQUMsQ0FBQztJQUM3QixDQUFDOztBQXhCSCwwQ0F5QkM7OztBQUVELE1BQU0saUJBQWlCLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO0FBRXRFOzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQW9CRztBQUNILE1BQXNCLFVBQVU7SUFDOUI7O09BRUc7SUFDSSxNQUFNLENBQUMsU0FBUyxDQUFDLFFBQXFCLEVBQUUsS0FBaUI7UUFDOUQsNkVBQTZFO1FBQzdFLDhFQUE4RTtRQUM5RSxnQ0FBZ0M7UUFDL0IsUUFBZ0IsQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHLEtBQUssQ0FBQztJQUMvQyxDQUFDO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsRUFBRSxDQUFDLFFBQXFCO1FBQ3BDLE1BQU0sR0FBRyxHQUFJLFFBQWdCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUNqRCxJQUFJLENBQUMsR0FBRyxFQUFFO1lBQ1IsTUFBTSxJQUFJLEtBQUssQ0FBQyxHQUFHLFFBQVEsNEVBQTRFLENBQUMsQ0FBQztTQUMxRztRQUNELE9BQU8sR0FBRyxDQUFDO0lBQ2IsQ0FBQztJQUVEOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxHQUFHLENBQUMsUUFBcUI7UUFDckMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNCLENBQUM7O0FBNUJILGdDQXFDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tICcuL2NvbnN0cnVjdCc7XG5cbi8qKlxuICogVHJhaXQgbWFya2VyIGZvciBjbGFzc2VzIHRoYXQgY2FuIGJlIGRlcGVuZGVkIHVwb25cbiAqXG4gKiBUaGUgcHJlc2VuY2Ugb2YgdGhpcyBpbnRlcmZhY2UgaW5kaWNhdGVzIHRoYXQgYW4gb2JqZWN0IGhhc1xuICogYW4gYElEZXBlbmRhYmxlVHJhaXRgIGltcGxlbWVudGF0aW9uLlxuICpcbiAqIFRoaXMgaW50ZXJmYWNlIGNhbiBiZSB1c2VkIHRvIHRha2UgYW4gKG9yZGVyaW5nKSBkZXBlbmRlbmN5IG9uIGEgc2V0IG9mXG4gKiBjb25zdHJ1Y3RzLiBBbiBvcmRlcmluZyBkZXBlbmRlbmN5IGltcGxpZXMgdGhhdCB0aGUgcmVzb3VyY2VzIHJlcHJlc2VudGVkIGJ5XG4gKiB0aG9zZSBjb25zdHJ1Y3RzIGFyZSBkZXBsb3llZCBiZWZvcmUgdGhlIHJlc291cmNlcyBkZXBlbmRpbmcgT04gdGhlbSBhcmVcbiAqIGRlcGxveWVkLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElEZXBlbmRhYmxlIHtcbiAgLy8gRW1wdHksIHRoaXMgaW50ZXJmYWNlIGlzIGEgdHJhaXQgbWFya2VyXG59XG5cbi8qKlxuICogQSBzZXQgb2YgY29uc3RydWN0cyB0byBiZSB1c2VkIGFzIGEgZGVwZW5kYWJsZVxuICpcbiAqIFRoaXMgY2xhc3MgY2FuIGJlIHVzZWQgd2hlbiBhIHNldCBvZiBjb25zdHJ1Y3RzIHdoaWNoIGFyZSBkaXNqb2ludCBpbiB0aGVcbiAqIGNvbnN0cnVjdCB0cmVlIG5lZWRzIHRvIGJlIGNvbWJpbmVkIHRvIGJlIHVzZWQgYXMgYSBzaW5nbGUgZGVwZW5kYWJsZS5cbiAqXG4gKiBAZXhwZXJpbWVudGFsXG4gKi9cbmV4cG9ydCBjbGFzcyBEZXBlbmRlbmN5R3JvdXAgaW1wbGVtZW50cyBJRGVwZW5kYWJsZSB7XG4gIHByaXZhdGUgcmVhZG9ubHkgX2RlcHMgPSBuZXcgQXJyYXk8SURlcGVuZGFibGU+KCk7XG5cbiAgY29uc3RydWN0b3IoLi4uZGVwczogSURlcGVuZGFibGVbXSkge1xuICAgIGNvbnN0IHNlbGYgPSB0aGlzO1xuXG4gICAgRGVwZW5kYWJsZS5pbXBsZW1lbnQodGhpcywge1xuICAgICAgZ2V0IGRlcGVuZGVuY3lSb290cygpIHtcbiAgICAgICAgY29uc3QgcmVzdWx0ID0gbmV3IEFycmF5PElDb25zdHJ1Y3Q+KCk7XG4gICAgICAgIGZvciAoY29uc3QgZCBvZiBzZWxmLl9kZXBzKSB7XG4gICAgICAgICAgcmVzdWx0LnB1c2goLi4uRGVwZW5kYWJsZS5vZihkKS5kZXBlbmRlbmN5Um9vdHMpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy5hZGQoLi4uZGVwcyk7XG4gIH1cblxuICAvKipcbiAgICogQWRkIGEgY29uc3RydWN0IHRvIHRoZSBkZXBlbmRlbmN5IHJvb3RzXG4gICAqL1xuICBwdWJsaWMgYWRkKC4uLnNjb3BlczogSURlcGVuZGFibGVbXSkge1xuICAgIHRoaXMuX2RlcHMucHVzaCguLi5zY29wZXMpO1xuICB9XG59XG5cbmNvbnN0IERFUEVOREFCTEVfU1lNQk9MID0gU3ltYm9sLmZvcignQGF3cy1jZGsvY29yZS5EZXBlbmRhYmxlVHJhaXQnKTtcblxuLyoqXG4gKiBUcmFpdCBmb3IgSURlcGVuZGFibGVcbiAqXG4gKiBUcmFpdHMgYXJlIGludGVyZmFjZXMgdGhhdCBhcmUgcHJpdmF0ZWx5IGltcGxlbWVudGVkIGJ5IG9iamVjdHMuIEluc3RlYWQgb2ZcbiAqIHNob3dpbmcgdXAgaW4gdGhlIHB1YmxpYyBpbnRlcmZhY2Ugb2YgYSBjbGFzcywgdGhleSBuZWVkIHRvIGJlIHF1ZXJpZWRcbiAqIGV4cGxpY2l0bHkuIFRoaXMgaXMgdXNlZCB0byBpbXBsZW1lbnQgY2VydGFpbiBmcmFtZXdvcmsgZmVhdHVyZXMgdGhhdCBhcmVcbiAqIG5vdCBpbnRlbmRlZCB0byBiZSB1c2VkIGJ5IENvbnN0cnVjdCBjb25zdW1lcnMsIGFuZCBzbyBzaG91bGQgYmUgaGlkZGVuXG4gKiBmcm9tIGFjY2lkZW50YWwgdXNlLlxuICpcbiAqIEBleGFtcGxlXG4gKlxuICogLy8gVXNhZ2VcbiAqIGNvbnN0IHJvb3RzID0gRGVwZW5kYWJsZVRyYWl0LmdldChjb25zdHJ1Y3QpLmRlcGVuZGVuY3lSb290cztcbiAqXG4gKiAvLyBEZWZpbml0aW9uXG4gKiBEZXBlbmRhYmxlVHJhaXQuaW1wbGVtZW50KGNvbnN0cnVjdCwge1xuICogICBnZXQgZGVwZW5kZW5jeVJvb3RzKCkgeyByZXR1cm4gW107IH1cbiAqIH0pO1xuICpcbiAqIEBleHBlcmltZW50YWxcbiAqL1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIERlcGVuZGFibGUge1xuICAvKipcbiAgICogVHVybiBhbnkgb2JqZWN0IGludG8gYW4gSURlcGVuZGFibGUuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGltcGxlbWVudChpbnN0YW5jZTogSURlcGVuZGFibGUsIHRyYWl0OiBEZXBlbmRhYmxlKSB7XG4gICAgLy8gSSB3b3VsZCBhbHNvIGxpa2UgdG8gcmVmZXJlbmNlIGNsYXNzZXMgKHRvIGN1dCBkb3duIG9uIHRoZSBsaXN0IG9mIG9iamVjdHNcbiAgICAvLyB3ZSBuZWVkIHRvIG1hbmFnZSksIGJ1dCB3ZSBjYW4ndCBkbyB0aGF0IGVpdGhlciBzaW5jZSBqc2lpIGRvZXNuJ3QgaGF2ZSB0aGVcbiAgICAvLyBjb25jZXB0IG9mIGEgY2xhc3MgcmVmZXJlbmNlLlxuICAgIChpbnN0YW5jZSBhcyBhbnkpW0RFUEVOREFCTEVfU1lNQk9MXSA9IHRyYWl0O1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybiB0aGUgbWF0Y2hpbmcgRGVwZW5kYWJsZSBmb3IgdGhlIGdpdmVuIGNsYXNzIGluc3RhbmNlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBvZihpbnN0YW5jZTogSURlcGVuZGFibGUpOiBEZXBlbmRhYmxlIHtcbiAgICBjb25zdCByZXQgPSAoaW5zdGFuY2UgYXMgYW55KVtERVBFTkRBQkxFX1NZTUJPTF07XG4gICAgaWYgKCFyZXQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgJHtpbnN0YW5jZX0gZG9lcyBub3QgaW1wbGVtZW50IElEZXBlbmRhYmxlLiBVc2UgXCJEZXBlbmRhYmxlLmltcGxlbWVudCgpXCIgdG8gaW1wbGVtZW50YCk7XG4gICAgfVxuICAgIHJldHVybiByZXQ7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJuIHRoZSBtYXRjaGluZyBEZXBlbmRhYmxlIGZvciB0aGUgZ2l2ZW4gY2xhc3MgaW5zdGFuY2UuXG4gICAqIEBkZXByZWNhdGVkIHVzZSBgb2ZgXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGdldChpbnN0YW5jZTogSURlcGVuZGFibGUpOiBEZXBlbmRhYmxlIHtcbiAgICByZXR1cm4gdGhpcy5vZihpbnN0YW5jZSk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIHNldCBvZiBjb25zdHJ1Y3RzIHRoYXQgZm9ybSB0aGUgcm9vdCBvZiB0aGlzIGRlcGVuZGFibGVcbiAgICpcbiAgICogQWxsIHJlc291cmNlcyB1bmRlciBhbGwgcmV0dXJuZWQgY29uc3RydWN0cyBhcmUgaW5jbHVkZWQgaW4gdGhlIG9yZGVyaW5nXG4gICAqIGRlcGVuZGVuY3kuXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgZGVwZW5kZW5jeVJvb3RzOiBJQ29uc3RydWN0W107XG59XG4iXX0=