# util-captcha

- Captcha with default

  ![](https://gitee.com/full-stack-web/util-captcha/raw/master/examples/captcha-default.png)

- Captcha with Noise dots

  ![](https://gitee.com/full-stack-web/util-captcha/raw/master/examples/captcha-noise_dots.png)

- Captcha with space evenly

  ![](https://gitee.com/full-stack-web/util-captcha/raw/master/examples/captcha-space_evenly-True.png)

  ![](https://gitee.com/full-stack-web/util-captcha/raw/master/examples/captcha-space_evenly-False.png)

- Base64 data

  <details>
    <summary>View</summary>

  data:image/png;base64,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

  </details>

## Introduction

A library that generates image CAPTCHAs.

## Installation

```bash
pip install util-captcha
```

## Usage

```py
from util_captcha import ImageCaptcha

image_captcha = ImageCaptcha()

# generate default captcha
image_captcha.draw_chars()
image_captcha.draw_noise_curve()
image_captcha.draw_noise_dots()
image_captcha.canvas.save("./examples/captcha-default.png")

# generate captcha of only noise dots
image_captcha.redraw()  # redraw canvas (required)
image_captcha.draw_chars()
image_captcha.draw_noise_dots(333)
image_captcha.canvas.save("./examples/captcha-noise_dots.png")

# generate captcha by space evenly
image_captcha.redraw()  # redraw canvas (required)
image_captcha.draw_chars("abc", space_evenly=True)
image_captcha.canvas.save("./examples/captcha-space_evenly-True.png")
image_captcha.redraw()  # redraw canvas (required)
image_captcha.draw_chars("abc", space_evenly=False)
image_captcha.canvas.save("./examples/captcha-space_evenly-False.png")

# use base64 data to generate captcha
image_captcha.redraw()  # redraw canvas (required)
image_captcha.draw_chars("base64")
data = image_captcha.generate_base64()
print(data)
```
