#  MIT License
#
#  Copyright (c) 2019 Jac. Beekers
#
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.
#

#  MIT License
#
#
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#
#

import logging, datetime, supporting
from supporting import errorcodes
from cicd.informatica import infaSettings
from supporting import generalSettings
from cicd.informatica import manageSecurity
import sys, argparse

now = datetime.datetime.now()
result = errorcodes.OK


def parse_the_arguments(argv):
    """Parses the provided arguments and exits on an error.
    Use the option -h on the command line to get an overview of the required and optional arguments.
     """
    parser = argparse.ArgumentParser()
    parser.add_argument("-i", "--inputfile", required=True, action="store", dest="input_file",
                        help="File that contains the exported users and groups. Tip: Include the path.")
    parser.add_argument("-r", "--reuse", required=False, action="store", dest="reuse",
                        choices=["false", "true"],
                        help="If set to true and a user or group already exists, the exising user or group will be re-used. If set to false, any existing user or group will be overwritten. Default is >true<.")
    args = parser.parse_args()

    if args.reuse is None:
        args.reuse = "true"

    return args


def main(argv):
    """Import users and groups from a file. The file has to be generated by exportUsersAndGroups.py or a self-made corresponding infacmd command line.
    usage: importUsersAndGroups.py [-h] -i INPUT_FILE [-r {false,true}]
    where:
    -r determines whether (true) or not (false) existing users and groups in the target environment should be re-used.
    Check the Informatica documentation for further information on importing users and groups with infacmd.
    """
    thisproc = "MAIN"
    mainProc = 'importUsersAndGroups'

    resultlogger = supporting.configurelogger(mainProc)
    logger = logging.getLogger(mainProc)

    args = parse_the_arguments(argv)

    generalSettings.getenvvars()

    supporting.log(logger, logging.DEBUG, thisproc, 'Started')
    supporting.log(logger, logging.DEBUG, thisproc, 'logDir is >' + generalSettings.logDir + "<.")

    import_file_name = args.input_file
    reuse_domain_users_and_groups = args.reuse

    infaSettings.getinfaenvvars()
    infaSettings.outinfaenvvars()

    users_and_groups = manageSecurity.ManageSecurity(Tool="ImportUsersAndGroups",
                                                     Domain=infaSettings.sourceDomain,
                                                     ExportFile=import_file_name,
                                                     ReuseDomainUsersAndGroups=reuse_domain_users_and_groups,
                                                     OnError=errorcodes.INFACMD_IMPORT_USRGRP_FAILED
                                                     )

    result = manageSecurity.ManageSecurity.manage(users_and_groups)

    supporting.log(logger, logging.DEBUG, thisproc, 'Completed with return code >' + str(result.rc)
                   + '< and result code >' + result.code + "<.")
    supporting.exitscript(resultlogger, result)


if __name__ == '__main__':
    main(sys.argv[1:])
