"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cf = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_origins_1 = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../../extensions");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'convert-query-string-demo', {
    env: { account: cdk.Aws.ACCOUNT_ID, region: 'us-east-1' },
});
/**
 * create an extension (L@E)
 * keys defined in a whitelist, or `ConvertQueryStringProps`, will become
 * custom headers with 'x-' prefixed.
 */
const convertQueryStringProsp = { args: ['language', 'name'] };
const convertQueryString = new extensions.ConvertQueryString(stack, 'LambdaEdge', convertQueryStringProsp);
/*
 * If you deploy this demonstration in another region other than us-east-1, your
 * closest edge location might not be what you expect. Change the price class
 * accordingly based on your anticipation.
 *
 */
// A CloudFront distribution with the L@E
const cloudFrontDistribution = new cf.Distribution(stack, 'CloudFrontDistribution', {
    defaultBehavior: {
        origin: new aws_cloudfront_origins_1.HttpOrigin('postman-echo.com', {
            httpPort: 80,
            originSslProtocols: [cf.OriginSslPolicy.TLS_V1],
            keepaliveTimeout: cdk.Duration.seconds(10),
            protocolPolicy: cf.OriginProtocolPolicy.HTTP_ONLY,
            readTimeout: cdk.Duration.seconds(10),
        }),
        edgeLambdas: [convertQueryString],
        cachePolicy: new cf.CachePolicy(stack, 'DefaultCachePolicy', {
            cachePolicyName: 'ConvertQueryString-Cache-Policy',
            queryStringBehavior: cf.CacheQueryStringBehavior.all(),
        }),
        originRequestPolicy: new cf.OriginRequestPolicy(stack, 'RequestPolicy', {
            originRequestPolicyName: 'ConvertQueryString-Request-Policy',
            queryStringBehavior: cf.OriginRequestQueryStringBehavior.all(),
            headerBehavior: cf.OriginRequestHeaderBehavior.all(),
            comment: 'just for demonstration.',
        }),
    },
    comment: 'The CloudFront distribution based on the custom origin',
    priceClass: cf.PriceClass.PRICE_CLASS_200,
});
new cdk.CfnOutput(stack, 'CopyRightValueAndPasteToBrowser', {
    value: `${cloudFrontDistribution.distributionDomainName}/get?language=english&name=viola&mood=hakunamatata`,
});
//# sourceMappingURL=data:application/json;base64,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