<div align="left">
  <img src="docs/source/_static/logo-purple-text.svg"><br>
</div>

# Openlayer | Python API Library

[![PyPI Latest Release](https://img.shields.io/pypi/v/openlayer.svg)](https://pypi.org/project/openlayer/)
[![downloads](https://pepy.tech/badge/openlayer)](https://pepy.tech/project/openlayer)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)

## What is it?

Openlayer is a debugging workspace for ML & Data Science. Openlayer combines and builds upon SOTA techniques in explainability, model and dataset versioning, synthetic data generation, data-centric testing and much more to form a powerful, **unified platform for model development**.

👉 [Join our Slack community!](https://l.linklyhq.com/l/1DG73) We'd love to meet you and help you get started with Openlayer!

This is the official Python library for interacting with the Openlayer platform. Navigate [here](https://docs.openlayer.com) for a quickstart guide and for in-depth tutorials.

## Main Features

This library's primary function is to enable you to easily package your models and datasets and add them to your Openlayer account.

## Installation

Install with PyPI (pip)

```console
pip install --upgrade openlayer
```

or install with Anaconda (conda)

```console
conda install openlayer --channel conda-forge
```

## Documentation

The official documentation for this Python library can be found [here](https://reference.openlayer.com).

## Contributing

All contributions, bug reports, bug fixes, documentation improvements, enhancements, and ideas are welcome! Just send us a message on [Slack](https://l.linklyhq.com/l/1DG73).
