#!/usr/bin/python
# -*- coding: utf-8 -*-

#  Copyright (C) 2021 David Arroyo Menéndez

#  Author: David Arroyo Menéndez <davidam@gmail.com>
#  Maintainer: David Arroyo Menéndez <davidam@gmail.com>
#  This file is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3, or (at your option)
#  any later version.
#
#  This file is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with damedb; see the file LICENSE.  If not, write to
#  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA 02110-1301 USA,

from unittest import TestCase
import psycopg2


class TestPSQL(TestCase):
    def test_connect(self):
        conn = psycopg2.connect("dbname=davidam user=davidam")

        # Open a cursor to perform database operations
        cur = conn.cursor()

        # Execute a command: this creates a new table
        #cur.execute("CREATE TABLE test (id serial PRIMARY KEY, num integer, data varchar);")

        # Pass data to fill a query placeholders and let Psycopg perform
        # the correct conversion (no more SQL injections!)
        # cur.execute("INSERT INTO test (num, data) VALUES (%s, %s)",
        #             (100, "abc'def"))

        # Query the database and obtain data as Python objects
        cur.execute("SELECT * FROM test;")
        x = cur.fetchone()

        # Make the changes to the database persistent
        conn.commit()

        # Close communication with the database
        cur.close()
        conn.close()

        self.assertEqual(x, (1, 100, "abc'def"))
