# Release 2.7.0

## Summary
This is a smaller release in terms of commits but still manages to introduce three new features and a few bug fixes. Namely, the `dockerfile lock` functionality now works for multistage Dockerfiles. We also added a complementary feature to the `--live` functionality that can take in one or more layer SBOMs and reason about them in context with the current layer during a `--live` Tern run. Currently, this feature only works for Tern-produced JSON formatted SBOMs. Lastly, the package type was added to the default report which indicates to the user the method of metadata collection that was used for the layer. A bug was also fixed that should enable the Tern + Scancode execution path to run without error when collecting package metadata.

## New Features
* [Enable Dockerfile "locking" for multistage builds](https://github.com/tern-tools/tern/issues/969): Tern's `dockerfile lock` command now works for multistage Dockerfiles.
* [Add functionality for consuming JSON reports](https://github.com/tern-tools/tern/issues/946): This feature introduces the CLI argument `--with-context` or `-ctx` which takes a list of reports that can provide previous context for container builds. This argument is meant to be used with the `--live` option to input reports from previous runs.
* [Show package type in default report](https://github.com/tern-tools/tern/issues/984): This feature updates the default report to include the package type in the report (i.e. deb, rpm, etc). This might be helpful for users who want to look for source code for the package or those who simply want to know what package manger was used to collect the information outputted in the report.

## Bug Fixes
* [Error getting package licenses with Scancode](https://github.com/tern-tools/tern/issues/985)
* [Can't generate html output when running Scancode](https://github.com/tern-tools/tern/issues/844)
* [Fix live execution if no previous SBOMs are given](https://github.com/tern-tools/tern/commit/273e3c8cd8969df3dacc56c5d878d65378d8e4bf)

## Future Work
* Use skopeo to pull container images
* Automate parts of the release process
* Investigation for potential support of CycleDX BOM format
* Add functionality for consuming SPDX JSON reports

## Changelog
Note: This changelog will not include these release notes

Changelog generated by command: `git log --pretty=format:"%h %s" v2.6.1..main`

```
273e3c8 Fix live execution if no previous sboms are given
20573c4 Fix Scancode collection of package licenses
b8e7837 Show package type in default report
e62a6c1 Bump debian-inspector version
81f441c Make "tern lock" work for multistage docker file
8ae40cc Fix prereqs.fs_shell variable naming
383905a Introduce JSON consumer
2d295cf Fix diffing of packages in layers
fce138b Connect machinery to ingest previous reports
1e167fa main: Add command line arg for consuming reports
ccec6cd Install scancode in /install
95acf0a Install scancode with fixed dependencies
0c46292 formats: Add layer level JSON consumer
837f3aa formats: Add consumer abstract base class
```

## Contributors
```
Jeroen Knoops jeroen.knoops@philips.com
Mukul Taneja mtaneja@vmware.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com

