# Release 2.6.1

## Summary
This release includes the usual mix of features, bug fixes and resolved technical debt. Namely, this release adds the ability to inventory a container at build time. When paired with other container build tools, this feature makes it possible to package and distribute the container SBoM with a container image, which eliminates the need for post-build scanning. Additionally, default reports were reformatted to better organize and display package metadata in a table instead of a list which makes it easier to associate licenses found in the container with the packages they belong to. 

A number of bugs were also resolved in this release. Most importantly, Tern now properly collects and reports on file information from Scancode, drastically improving the accuracy of the reports generated with Tern + Scancode. Tern's run time performance has also improved significantly with the removal of regex based filtering in some files.

NOTE: Due to human error, we had to bump the intended 2.6.0 release version to version 2.6.1. This doesn't change the contents of the release.

## New Features
* [Generate SBoMs at container build time](https://github.com/tern-tools/tern/issues/849): This feature enables Tern to inventory and generate an SBoM against a mounted container filesystem. This feature is meant to work along with other container build tools and scripts. 
* [Display layer packages in a table format](https://github.com/tern-tools/tern/issues/930): The default report now represents package metadata in a formatted table instead of a list. This makes the reports cleaner and easier to understand.
* [Add copyright info for NPM packages](https://github.com/tern-tools/tern/issues/957): Tern can now provide copyright information for NPM packages in the JSON, YAML, HTML and SPDX reports.

## Bug Fixes
* [Scancode not producing file or file license info](https://github.com/tern-tools/tern/issues/959)
* [AttributeError when using debug subcommand](https://github.com/tern-tools/tern/issues/967)
* [Infinite notices are reported](https://github.com/tern-tools/tern/issues/942)
* [Scancode errors when collecting pip package information](https://github.com/tern-tools/tern/issues/964)

## Resolved Technical Debt
* [Remove regex based filtering to increase run performance](https://github.com/tern-tools/tern/issues/939)
* [Add 'Understanding the Reports' section to README](https://github.com/tern-tools/tern/issues/960)
* [Update 'debut' dependency to reflect new 'debian-inspector' name](https://github.com/tern-tools/tern/issues/961)
* [Use dpkg-query to avoid using cut and awk utilities](https://github.com/tern-tools/tern/issues/936)

## Future Work
* Enable Dockerfile "locking" for multistage docker builds
* Use skopeo to pull container images

## Changelog
Note: This changelog will not include these release notes

Changelog generated by command: `git log --pretty=format:"%h %s" v2.5.0..main`

```
1531c25 Prepare for Release 2.6.0
6ada44b Record and report scancode file licenses
22ac183 Update README with Cybersecurity EO/SPDX info
63def2d Add 'Understanding the Reports' section to README
1bc7588 Added copyright info for NPM packages
90297ef Update debug execution path with prereqs object
f6535bb scancode: filter license from pip pkg classifiers
7fb3d1b Replace `debut` with `debian-inspector`
0bf92fd Better parsing of created_by values
385301e ADD/COPY command analysis by tern
52fd8f3 Fixed an issue with the export command
264de6c CI: Test lock with single stage Dockerfile
022659d Clean up lines in default report
a03e7d2 Deprecate command library commands in reports
cb99041 Update 'invoke_for_base' Notice verbiage
3710b08 Reorganize package metadata info in default report
c3a2a07 Reorganize package metadata info in default report
f6202a1 Add prettytable dep to reformat default report
31ce1bb Remove regex based filtering for prop_names
6315e26 Generate SBoMs at container build time
28024fd fix: Set layer creation notice only on cache miss
230d6d8 Add devcontainer configuration
22ef379 Handling the traceback in commit message linting
c66c842 Fix linting errors and cyclic import
9e015d0 SPDX JSON SBoM generation at container build time
1068bc5 Add reporting for OS type
4476383 Account for "host" scripts
551b0c4 Add JSON and YAML generator for layer object
a85cd0a Add HTML format for one layer object
7d98f61 Enable default format reporting for live run
448de80 Hook up --live with execution path
da3a869 Added a new option -l,--live to report subcommand
e57508b Introduce inventory of live container
66f81ea Use slim variant of Debian Buster as base image
86dc6e6 Add project_urls to debian based images
b71fc2b Use dpkg-query to list installed packages on debian
```

## Contributors
```
Cole Helbling cole.e.helbling@outlook.com
Dhairya Jain jaindhairya2001@gmail.com
Jamie Magee jamagee@microsoft.com
Jamie Magee jamie.magee@gmail.com
m1-key shubhamtiwari.tiwari84@gmail.com
Matej Zachar mzachar@simpleway.cz
Mukul Taneja mtaneja@vmware.com
quepop thequepop@gmail.com
Yann Jorelle yannjorelle@protonmail.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com

