# Release 1.0.0

## Summary
This is Tern's first major release. Our CLI has changed since the last release to account for two added features:
* The ability to add custom report formats using plugins (`-f,--format` option)
* The ability to add tool extensions using plugins (`-x, --extend` option)

We are still in alpha development mode, so the CLI might change in the future, in which case, expect another major release bump.

Apart from the addition of the above two major features, we have also included some bug fixes that have greatly improved the stability and robustness of the tool. We have also modified the default report format such that it gives you package and license information at a glance, as well as information regarding the container image itself. We find this format to be useful as a first pass evaluation of the contents and "reasonableness" of the container image.

We'd like to thank all those who contributed to this release, which is a significant milestone for the project.

## New Features
* [Report format plugins](/docs/creating-custom-templates.md): This allows data collected by Tern to be formatted in a custom way such that the tool can accomodate any team's internal automation and auditing processes.
* [Extending container analysis with external tools](/docs/creating-tool-extensions.md): This allows Tern to leverage license and other scanning tools to scan filesystems in a container image rather than building such scanning from scratch.

## Bug Fixes
* [Gracefully exit when an incorrect Python version is being used](https://github.com/vmware/tern/issues/362)
* [Fix incorrect reporting for filesystem where a package manager exists](https://github.com/vmware/tern/issues/362)
* [Extract tarballs where files are owned by root](https://github.com/vmware/tern/issues/433)
* [Workaround for Python tarfile not checking malicious tarballs](https://github.com/vmware/tern/issues/226)
* [Fix incorrect SPDX formatting for empty licenses](https://github.com/vmware/tern/issues/431)
* [Fix incorrect SPDX package download location](https://github.com/vmware/tern/issues/451)
* [Fix incorrect SPDX formatting for license reference](https://github.com/vmware/tern/issues/465)
* [Fix cleaning up after a keyboard interrupt](https://github.com/vmware/tern/issues/464)
* [Fix overwriting of notice messages in the cache](https://github.com/vmware/tern/issues/466)
* [Continue to analyze base image if Dockerfile build fails](https://github.com/vmware/tern/issues/450)
* [Gracefully exit if Docker is not installed or appropriately set up](https://github.com/vmware/tern/issues/207)
* [Remove hardcoded version string](https://github.com/vmware/tern/issues/432)

## Resolved Technical Debt
* [Refactor for allowing other types of container images](https://github.com/vmware/tern/issues/212)
* [CLI updates](https://github.com/vmware/tern/issues/390)
* [Replaced broken DockerImage class unit test with a functional test](https://github.com/vmware/tern/issues/458)

## Future Work
* We will be working on including file level metadata and support for language package managers.
* We will add a 'Dockerfile freeze' option that may be a new sub-command for the CLI. This is not a breaking change so the next release will be a minor bump.
* As usual, we will be refactoring code, addressing technical debt, and fixing bugs.

We expect that due to the winter holidays (US), the next release will be a small one which may include a subset of the changes we are working on. Watch the [project roadmap](/docs/project-roadmap.md) for updates.

## Changelog

Note: This changelog will not include these release notes

Changelog produced by command: `git log --pretty=format:"%h %s" 9d1cb9c..master`

```
692389b circleci: Remove auto deploy to PyPI
c9a0c83 merge: Documentation updates for Extensions
151222e docs: Added extensions to navigating the code doc
20cd677 docs: Update Contributing section in README
8606aed docs: Added link back to README in individual docs
80bf070 docs: Updates to architecture
1da1e75 docs: Updates to glossary
2e260d0 README: Added content for using tool extensions
8df8cf1 docs: Added creating extensions and data model
a041a8d docs: Update directions to activate venv
68cb125 docs: Update custom formats documentation
1edd813 extensions: Added initial scancode extension
a1ed695 tools: Fix imports for container_debug
edd8a0f Catch exceptions when docker is not set up
720142b docs: Fix lab tutorial formatting typo
568e18a docs: Add Strigo lab tutorial for Tern
bfde488 Soldier on if Dockerfile build fails
ecb225f Fix-up license summary for Dockerfile built images
e1d998e Fix soldiering on if Dockerfile build fails
8fa2f40 Fix info overwriting  when retrieving from cache
7dae5bf merge: Create external tool extensions
332d22b analyze: docker: Refactor to reduce complexity
73c1cc2 extentions: Enable cve-bin-tool
8f67601 extensions: Add cve-bin-tool extension
3b3baf4 extensions: Added setup for extension plugins
1255eb1 Enable cli to use raw container image
32c95c6 Merge: Precautions against external interference
19cffcd spdx: Remove invalid characters from LicenseRef
4efcb12 cache: move cache file to dot folder
03a7f6d tools: switch debug directory to hidden folder
6c8e581 Move working directory into hidden dot folder
ff535dc Safely unmount on keyboard interrupt
bd1f238 merge: Refactor docker image analysis to new module
e8ef5fb Refactor: deprecate tern/helpers folder
d62187d Refactor docker-specific analysis to new module
eefd676 docs: Update references in navigating-the-code.md
ae49494 Report package information by layer
7c3bbf2 Add analyzed_output property
4138384 Set PackageDownloadLocation as NOASSERTION
0d23324 ci: Replace unit test for DockerImage class
4d72f5e Create default report plugin and deprecate verbose
05a6689 Add files_analyzed property to ImageLayer
3dbde96 report: Add external tool passthrough
8fbc300 report: Add missing copyright and license header
98737a8 CLI: update command line 'report' options
0271b9d cli: Update "report" help info to be more useful
608705a Check tarballs before extracting
026e0a7 spdx: Handle reporting for empty license metadata
c095b73 merge: Untar tarballs files with root permissions
0e307ac utils: Added extra checks for extracting archives
551ec3c Extract tarballs in Ubuntu:14.04
871af9d Allow Tern to pull by digest
12b306f Check for binary after base image layer is mounted
864a00e docs: Updates based on current project status
ffb851d Refactor analyze_docker_image
3c5e2a2 fix: Remove hardcoded version string
3217fe6 ci/cd: Stop prospector errors for imports
79adc2f docs: update README to call yaml report correctly
a90bc66 Dockerfile: install tern using pip
f2e5888 requirements: Add stevedore
a46939b Wrap python2.7 error message
b853635 docs: Update README to call json report correctly
e596ff9 Separate YAML formatting into its own plugin
1a69aef Separate json formatting into its own plugin
9ce1d94 Remove dev-requirements.txt and redundancy in circleci
bf8d62d release: Modify deployment steps
```

## Contributors

```
PrajwalM2212 prajwalmmath@gmail.com
Manaswini Das dasmanaswini10@gmail.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com
