# Release 0.5.0

## Summary
This is a small release, mostly focused on setting up the project for continuous integration and continuous delivery. We went with CircleCI for these tasks. Plenty of tasks that we wanted to automate did not have either a native solution on CircleCI nor a GitHub app. These are specifically having to do with testing *commits* rather than the project as a whole. As a result, we created our own set of ci scripts. You can find them in the folder `ci`. These tests include:

* Evaluating if the commit changed something in the documentation rather than in code, in which case, no linting and security tests are done.
* Linting the commit message to see if it meets the project's guidelines.
* Running tests based on which files were changed by the commit.

We have had an opportunity to run these tests while developing on the projects and they seem to be behaving well. Thanks to everyone who contributed while we were putting these changes in place!

Tern now reports what OS a container is based on. This is a pretty cool feature as it gives you an idea of where an OS with no package manager may have come from. For example, Here's what the output looks for a Kubernetes image:
```
Docker image: k8s.gcr.io/addon-resizer:2.3:
        Layer: 58de108e9e:
                info: Found 'Distroless' in /etc/os-release.
                warning: Unable to find a known package manager. Cannot list packages.
```

This is the first release where we will be providing a PyPI package. Installation of this release should just require `pip install tern`.

## New Features
* CI/CD pipelines using CircleCI
* Report base OS of a container image
* First PyPI release

## Bug Fixes
* [Incorrect reporting with failure in running fs_hash.sh](https://github.com/vmware/tern/issues/263)
* [Add long_description_content_type to setup in setup.py](https://github.com/vmware/tern/issues/331)
* [Commit message linter only checks top-most commit in a git tree](https://github.com/vmware/tern/issues/309)
* [Tern doesn't split shell commands separated by a ';'](https://github.com/vmware/tern/issues/268)

## Resolved Technical Debt
* [Edit 'description' in setup.py](https://github.com/vmware/tern/issues/330)
* [Make test_suite a dictionary of lists instead of lists and strings](https://github.com/vmware/tern/issues/322)
* [Add missing SPDX copyright header to files](https://github.com/vmware/tern/issues/210)

## Future Work
Release 1.0.0 will be our first non-backwards-compatible release as we will be modifying some of our command line options to allow for pluggable reporting formats. We will also be addressing some technical debt and bug fixes as usual. We now have two maintainers so development is expected to move at a faster pace. PRs are still welcomed and very appreciated!

## Changelog

Note: This changelog will not include these release notes

Changelog produced by command: `git log --pretty=format:"%h %s" v0.4.0..master`

```
10993ee Install tern in dev mode
a7faac7 update dockerfile.py with raw string notation
ffe9bae ci/cd: Add a pre-deploy to use release reqs file
9f79c45 REVERT-ME: disable Travis
f8c3fc6 circleci: Change mirrors to prevent test failures
df0a6bc classes: Removed unnecessary pass
496bbb8 docs: Use pip-tools when cutting a release
acb12c9 tools: Added requirements.in file
9014c3a merge: ci: Enable TravisCI as a backup
1e146a5 ci: Run tests in parallel
66588b9 ci: TravisCI equivalent tests
a175e27 docs: Add a release checklist
5d5a21b Build a binary wheel of the Tern module for PyPI
440029a docs: Require wheel to be installed
bedaa88 Report base OS for image with /etc/os-release
605e289 Add git commit sha1 from git repo to -V option
08eded6 Pin requirements only upto the minor version
0505b3d Fix incorrect reporting when fs_hash.sh fails
114389d ci: Create build and release pipeline for Tern
fa2d035 Merge: Report Base OS of the container image
de9892f Fix vagrant documentation and bootstrap file
d600c95 Add a version argument to tern CLI
73a6f2f Added Checksum as a Package Property
125ed64 Add functionality to report repo style and distro
1cc3ca3 common.py: Add get_os_style function
cf7c50e command_lib: Change variable name for consistency
de7e0a7 command_lib: Add check_pkg_format function
6c2c183 Add pkg_format attribute to image_layer class
f7ff80e Add pkg_format to each package manager in base.yml
3da8063 docs:Improve CONTRIBUTING.md
a33ff89 ci: Fix commit linter not testing body
aacef0a ci/cd:Add long_description_content_type to setup.py
823454e Initial script to debug a container image
cb79319 tools: Add tool to debug a container image
f726510 utils: pep8: Fix line continuation error
958cdc3 report: Separate prep_rootfs from mount_overlay_fs
f80b91f Fix incorrect test to run in circleci
07aed34 Clean up PEP8 style inconsistencies in setup.py
e17360a Improves setup.py
64c03e0 ci: Fix pipe error if there are no changes
4b584d3 ci: Enable linting for each .py file in the PR
4dbae0c ci: Make test_suite a dictionary of lists
69d8082 ci: Fix another exit and print error
63abfc3 ci: Fix exit statement for change based tests
7b92c48 ci: Fix print statement and PEP8 errors
1ebf354 ci: Don't run prospector for .md file changes
6a58dbf Remove 'D' from utf header in test_files_touched.py
1b81acb Run tests based on which files were touched
fae8390 Remove tests/test_commit_message.py
f0ad6c8 docs: Add ci to directory list
bae07c0 fix: ci: Check for no commits
aebecdd Make sure commit linter checks all commits
3f69a60 Separate bandit and prospector linting in circleci
d51fdd1 Add GitPython dev requirement
0cba95a tests: Add commit message linting script
f55d428 Split and consolidate shell commands
f5d86ec helpers: Consolidate instances of the same command
b5efc01 classes: Added merge method to combine commands
db933d8 tern: Use split_command for long commands
d497d84 utils: Added function to split a command string
92db0c0 utils: Moved cleaning command strings to general
27538bd Add Bandit to linting tools
8ecab0d Create 'helpers' folder for a few module files
e19720e README: Replaced build badge with CircleCI badge
9e10511 circleci: Enable Prospector run for every commit
0cfedc9 report: spdxtagvalue: Fix Prospector errors
627e797 Cleanup and add missing SPDX copyright headers
36f1445 Removed .travis.yml
bc1a86a Add Circle CI config file
0d76415 README: Break up unnecessarily long sentence
```

## Contributors

```
PrajwalM2212 prajwalmmath@gmail.com
Kieran McGuire kdmcguire1@gmail.com
Khayam Anjam khayam.gondal@gmail.com
manaswinidas dasmanaswini10@gmail.com
J.R. Garcia jrg@vmware.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com
