# Release 0.3.0

## Summary
This release is much smaller than the previous releases due to holidays in December and work towards conference CFPs. Much as I would have liked to have gotten some big ticket items done this time around, I think we've achieved a really big step in this release by containerizing Tern. This is one feature that a lot of organizations interested in integrating Tern wanted. It makes sense due to infrastructure moving towards running microservices in containers and connecting them together. Tern can still run in a desktop environment, so this is added functionality.

Also, since Tern is now part of the Linux Foundation, the roadmap has some additional features that need to be factored in. See the [project roadmap](/docs/project-roadmap.md) for more details on how the project benefits from this change.

## New Features

- Most of the changes went towards making Tern run in a container. This resulted in the addition of a Dockerfile and instructions to try Tern out using Docker. Here are the functional changes to make this happen:
```
7dbe6c0 Added Dockerfile and script to run in a container
6f7c0be Report out to stdout by default
10edeb2 Added -b option to work with bind mount directory
7cc9518 Enabled console logging as an option
ff99864 Remove logging's console StreamHandler
6e75f82 Call fs_hash.sh tool using root_command wrapper
389bafd Pull docker image if not on disk
6e46f5d Convert Docker CLI calls to Docker API calls
```
- The [Precaution app](https://github.com/apps/precaution) was enabled on the project, which caught some assert issues, and some warnings on using the subprocess module. Hence there is a commit to replace `assert` with `if-else` raising a `TypeError`, and one that contains a bunch of `# nosec` comments to ignore these warnings.
```
cf3146a Dismiss security issues for subprocess and random
aca9441 Fixed issues discovered by security linter
```
- A listing for binary `tdnf` was added to the Command Library.
- There were also a number of changes that were targeted towards project hygiene and readability.
```
659ee65 Added a demo gif
e275193 Updated docs and project roadmap
0cebdd2 Refactor: Move all source code to src folder
```
## Bug Fixes
* [Tern crashes when running in a container](https://github.com/vmware/tern/issues/153)
* [Tern report fails with error: 'Origins' object has no attribute 'add_notice_origins'](https://github.com/vmware/tern/issues/142)

## Future Work
Release 0.4.0 will be focused on enabling SPDX formatted output. See the [project roadmap](/docs/project-roadmap.md) for more details.

## Changelog

Note: this changelog will not include these release notes

```
659ee65 Added a demo gif
e275193 Updated docs and project roadmap
cf3146a Dismiss security issues for subprocess and random
0cebdd2 Refactor: Move all source code to src folder
aca9441 Fixed issues discovered by security linter
7dbe6c0 Added Dockerfile and script to run in a container
6f7c0be Report out to stdout by default
10edeb2 Added -b option to work with bind mount directory
1473fa9 Added listing for tdnf command
7cc9518 Enabled console logging as an option
ff99864 Remove logging's console StreamHandler
6e75f82 Call fs_hash.sh tool using root_command wrapper
389bafd Pull docker image if not on disk
6e46f5d Convert Docker CLI calls to Docker API calls
e6017a8 Updated git stash commands in dealing with cache
0a77e2d Rename docker.py to docker_helpers.py
7650ac8 Fix typo for adding a notice to list of origins
```

## Contact the Maintainer

Email: nishak@vmware.com

Twitter: @nishakmr
