# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from wordsapi.api_helper import APIHelper
from wordsapi.models.syllable_details import SyllableDetails
from wordsapi.models.word_details import WordDetails


class WordResponse(object):

    """Implementation of the 'WordResponse' model.

    This custom type contains the response for word API.

    Attributes:
        word (string): The word that is searched.
        results (list of WordDetails): This field contains detailed
            information of the word.
        pronunciation (object): This model contains pronunciation details of a
            specific word.
        frequency (float): The frequency of the word usage.
        syllables (SyllableDetails): This custom type contains the syllable
            details for word API.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "word": 'word',
        "results": 'results',
        "pronunciation": 'pronunciation',
        "frequency": 'frequency',
        "syllables": 'syllables'
    }

    _optionals = [
        'word',
        'results',
        'pronunciation',
        'frequency',
        'syllables',
    ]

    _nullables = [
        'word',
        'results',
        'pronunciation',
        'frequency',
    ]

    def __init__(self,
                 word=APIHelper.SKIP,
                 results=APIHelper.SKIP,
                 pronunciation=APIHelper.SKIP,
                 frequency=APIHelper.SKIP,
                 syllables=APIHelper.SKIP):
        """Constructor for the WordResponse class"""

        # Initialize members of the class
        if word is not APIHelper.SKIP:
            self.word = word 
        if results is not APIHelper.SKIP:
            self.results = results 
        if pronunciation is not APIHelper.SKIP:
            self.pronunciation = pronunciation 
        if frequency is not APIHelper.SKIP:
            self.frequency = frequency 
        if syllables is not APIHelper.SKIP:
            self.syllables = syllables 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        word = dictionary.get("word") if "word" in dictionary.keys() else APIHelper.SKIP
        if 'results' in dictionary.keys():
            results = [WordDetails.from_dictionary(x) for x in dictionary.get('results')] if dictionary.get('results') else None
        else:
            results = APIHelper.SKIP
        pronunciation = dictionary.get("pronunciation") if "pronunciation" in dictionary.keys() else APIHelper.SKIP
        frequency = dictionary.get("frequency") if "frequency" in dictionary.keys() else APIHelper.SKIP
        syllables = SyllableDetails.from_dictionary(dictionary.get('syllables')) if 'syllables' in dictionary.keys() else APIHelper.SKIP 
        # Return an object of this model
        return cls(word,
                   results,
                   pronunciation,
                   frequency,
                   syllables)
