# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from wordsapi.api_helper import APIHelper


class PronunciationDetails(object):

    """Implementation of the 'PronunciationDetails' model.

    This model contains pronunciation details of a specific word.

    Attributes:
        all (string): The pronunciation of the word.
        noun (string): The noun pronunciation of the word.
        verb (string): The verb pronunciation of the word.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "all": 'all',
        "noun": 'noun',
        "verb": 'verb'
    }

    _optionals = [
        'all',
        'noun',
        'verb',
    ]

    _nullables = [
        'all',
        'noun',
        'verb',
    ]

    def __init__(self,
                 all=APIHelper.SKIP,
                 noun=APIHelper.SKIP,
                 verb=APIHelper.SKIP):
        """Constructor for the PronunciationDetails class"""

        # Initialize members of the class
        if all is not APIHelper.SKIP:
            self.all = all 
        if noun is not APIHelper.SKIP:
            self.noun = noun 
        if verb is not APIHelper.SKIP:
            self.verb = verb 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        all = dictionary.get("all") if "all" in dictionary.keys() else APIHelper.SKIP
        noun = dictionary.get("noun") if "noun" in dictionary.keys() else APIHelper.SKIP
        verb = dictionary.get("verb") if "verb" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(all,
                   noun,
                   verb)
