# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from wordsapi.api_helper import APIHelper


class DefinitionsResponse(object):

    """Implementation of the 'DefinitionsResponse' model.

    This custom type contains response for definitions endpoint.

    Attributes:
        word (string): The word that is searched.
        definition (list of string): The definitions of the searched word.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "word": 'word',
        "definition": 'definition'
    }

    _optionals = [
        'word',
        'definition',
    ]

    _nullables = [
        'word',
        'definition',
    ]

    def __init__(self,
                 word=APIHelper.SKIP,
                 definition=APIHelper.SKIP):
        """Constructor for the DefinitionsResponse class"""

        # Initialize members of the class
        if word is not APIHelper.SKIP:
            self.word = word 
        if definition is not APIHelper.SKIP:
            self.definition = definition 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        word = dictionary.get("word") if "word" in dictionary.keys() else APIHelper.SKIP
        definition = dictionary.get("definition") if "definition" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(word,
                   definition)
