# mass-spec-python-tools: mass spec made easier

### What is it?
This is a collection of scripts to aid in the processing and interpretation of mass spectrometric data. 

The project was created by Lars Yunker in the [McIndoe group](https://web.uvic.ca/~mcindoe/) 
at the University of Victoria, Victoria, BC, Canada. 

If you use these tools in your research endeavours, please cite 
[Yunker _et al._ _J. Chem. Inf. Model._, **2019**, _59_(4) pp 1295-1300](https://pubs.acs.org/doi/10.1021/acs.jcim.9b00055).

### Requirements and Installation:
This package has been written for python 3.5+.

##### Getting started

This framework is available on PyPI. To install, execute

`pip install pythoms`

in the command line on a Python-configured computer. If you do not yet have Python on your computer, there are many 
excellent tutorials on accomplishing this. 

PyPI installations do not include the scripts in this repository.
If you wish to use these scripts, download the entire repository to a
folder on your computer, run `python setup.py install` with that
folder as the current working directory (this installs the dependencies),
and execute the scripts as needed.

* Python users interested in applying the scripts directly can edit the
    input parameters in the files.
* Developers can import many of the classes to create scripts tailored to
    their needs.

To help novice users, a [tutorial video for PythoMS installation on Windows](https://www.youtube.com/watch?v=3p2CoOgjIWY) is available. 

### Tutorials
We have created tutorial videos on the use of several scripts in this package: 

- [Converting Waters MassLynx RAW files to mzML](https://www.youtube.com/watch?v=Fg9zjEY-DPs)
- [Isotope pattern overlay script](https://www.youtube.com/watch?v=PPyNq1Szt6s)
- [PyRSIR (Python Reconstructed Single Ion Recording) script](https://www.youtube.com/watch?v=OuV4vUy2pGw) (there is also 
    [a video](https://www.youtube.com/watch?v=zc8i54EiCGY) on a much older version of the script, but it has some additional useful information)
- Video Renderer Script for [Windows](https://www.youtube.com/watch?v=BhhCdrqSF24) and [Mac](https://www.youtube.com/watch?v=cNYRiSVcNhU)

### Contributors

We welcome contributions, so if you're interested in contributing please
email larsy[at]uvic{dot}ca. Particularly, we are in need of mzML file
examples where the data was not generated by Proteowizard (intially from
a Waters instrument).

Many thanks to the following individuals for their contributions to PythoMS: 
- Sofia Donnecke
- Michelle Ting
- Darien Yeung
- J. Scott McIndoe

### Errors
If you encounter an error, please submit an Issue in Github with as much
information as possible.

Things that are helpful to include:
* the raw file you were trying to parse (zip it first)
* the exact parameters you were using
* any additional files you were supplying to the script
* the error output

### Scripts:

##### PyRSIR
This script takes supplied raw and parameters files and generates
reconstructred single ion monitoring traces. A [tutorial video](https://www.youtube.com/watch?v=OuV4vUy2pGw) is available. 

##### isotope pattern overlay
Takes a supplied mass spectrum and overlays the predicted isotope pattern
onto it. A [tutorial video](https://www.youtube.com/watch?v=PPyNq1Szt6s) is available.

##### video frame renderer
A tool for generating a series of images showing mass spectrum and
traces which can be combined into a video. Tutorial videos are available for both 
[Windows](https://www.youtube.com/watch?v=BhhCdrqSF24) and [Mac](https://www.youtube.com/watch?v=cNYRiSVcNhU)

##### y-axis zoom figure
Renders a series of images which zoom into the y-axis to illustrate the
dynamic range of mass spectrometers.

### Highlighted Modules
##### molecule
Contains classes for describing the physico-chemical properties of molecules.
The `IPMolecule` class contains algorithms for predicting the
isotope pattern of said molecule.

##### spectrum
Contains an efficient helper class for combining spectra of different
shape and managing impractically precise x values.

##### mzML
Contains classes for interacting with mzML files in a pythonic manner.

### License
These tools are licensed under the [MIT license](https://opensource.org/licenses/MIT).