
import os
import time
import datetime


class EnvironmentVariables:
    """
    This class manage environment variable parameters
    """
    def __init__(self):

        self._environment_variables_dict = {}

        ##################################################################################################
        # dynamic parameters - configure for local run
        # parameters for running workload

        # This path is github actions runner path (benchmark-operator should be cloned here)
        self._environment_variables_dict['runner_path'] = os.environ.get('RUNNER_PATH', '/tmp')
        # This path is for vm/pod run artifacts - solve vm capture issue
        self._environment_variables_dict['run_artifacts'] = os.environ.get('RUN_ARTIFACTS', '/tmp/run_artifacts')

        # dynamic parameters - configure for local run
        self._environment_variables_dict['workload'] = os.environ.get('WORKLOAD', '')
        self._environment_variables_dict['kubeadmin_password'] = os.environ.get('KUBEADMIN_PASSWORD', '')

        # PIN=node selector
        self._environment_variables_dict['pin_node_benchmark_operator'] = os.environ.get('PIN_NODE_BENCHMARK_OPERATOR', '')
        self._environment_variables_dict['pin_node1'] = os.environ.get('PIN_NODE1', '')
        self._environment_variables_dict['pin_node2'] = os.environ.get('PIN_NODE2', '')

        # ElasticSearch
        self._environment_variables_dict['elasticsearch'] = os.environ.get('ELASTICSEARCH', '')
        self._environment_variables_dict['elasticsearch_port'] = os.environ.get('ELASTICSEARCH_PORT', '')

        # default parameter - change only if needed
        # Parameters below related to 'run_workload()'
        self._environment_variables_dict['workloads'] = ['stressng_pod', 'stressng_vm', 'stressng_kata',
                                                         'uperf_pod', 'uperf_vm', 'uperf_kata',
                                                         'hammerdb_pod_mariadb', 'hammerdb_vm_mariadb', 'hammerdb_kata_mariadb',
                                                         'hammerdb_pod_postgres', 'hammerdb_vm_postgres', 'hammerdb_kata_postgres',
                                                         'hammerdb_pod_mssql', 'hammerdb_vm_mssql', 'hammerdb_kata_mssql']
        self._environment_variables_dict['namespace'] = os.environ.get('NAMESPACE', 'benchmark-operator')
        # run Hammerdb workload with ocs pvc True/False. True=OCS, False=Ephemeral
        self._environment_variables_dict['ocs_pvc'] = os.environ.get('OCS_PVC', 'True')
        # This parameter get from Test_CI.yml file
        self._environment_variables_dict['build_version'] = os.environ.get('BUILD_VERSION', '1.0.0')
        # collect system metrics True/False
        self._environment_variables_dict['system_metrics'] = os.environ.get('SYSTEM_METRICS', 'True')
        # CI status update once at the end of CI Pass/Failed
        self._environment_variables_dict['ci_status'] = os.environ.get('CI_STATUS', '')
        # Valid run types
        self._environment_variables_dict['run_types'] = ['test_ci', 'func_ci', 'perf_ci']
        # Run type test_ci/func_ci/perf_ci, default test_ci same environment as func_ci
        self._environment_variables_dict['run_type'] = os.environ.get('RUN_TYPE', 'test_ci')
        # Benchmark runner IBM Cloud Object Storage run artifacts hierarchy, not part of a POSIX path ('/' a key seperator, '-' file name convenstion )
        self._environment_variables_dict['date_key'] = datetime.datetime.now().strftime("%Y/%m/%d")
        self._environment_variables_dict['time_stamp_format'] = os.path.join(datetime.datetime.fromtimestamp(time.time()).strftime('%Y-%m-%d-%H-%M-%S'))
        # Benchmark runner local run artifacts path with time stamp format
        self._environment_variables_dict['run_artifacts_path'] = os.path.join(self._environment_variables_dict['run_artifacts'], f"{self._environment_variables_dict['workload'].replace('_', '-')}-{self._environment_variables_dict['time_stamp_format']}")
        # None(Default)/ 'True' to save local(/tmp) artifacts files
        self._environment_variables_dict['save_artifacts_local'] = os.environ.get('SAVE_ARTIFACTS_LOCAL', None)
        # None/ True(Default) to enable prometheus snapshot
        self._environment_variables_dict['enable_prometheus_snapshot'] = os.environ.get('ENABLE_PROMETHEUS_SNAPSHOT', 'True')
        # end dynamic parameters - configure for local run
        ##################################################################################################

        # ** DO NOT CHANGE THE PARAMETERS BELOW **
        # Constant parameters

        # Parameters below related to 'azure_cluster_start_stop()'
        # Azure details
        self._environment_variables_dict['azure_cluster_stop'] = os.environ.get('AZURE_CLUSTER_STOP', '')
        self._environment_variables_dict['azure_cluster_start'] = os.environ.get('AZURE_CLUSTER_START', '')
        self._environment_variables_dict['azure_clientid'] = os.environ.get('AZURE_CLIENTID', '')
        self._environment_variables_dict['azure_secret'] = os.environ.get('AZURE_SECRET', '')
        self._environment_variables_dict['azure_tenantid'] = os.environ.get('AZURE_TENANTID', '')
        self._environment_variables_dict['azure_subscriptionid'] = os.environ.get('AZURE_SUBSCRIPTIONID', '')
        self._environment_variables_dict['azure_resource_group_name'] = os.environ.get('AZURE_RESOURCE_GROUP_NAME', '')
        self._environment_variables_dict['azure_vm_name'] = os.environ.get('AZURE_VM_NAME', '')

        # IBM details
        self._environment_variables_dict['region_name'] = os.environ.get('IBM_REGION_NAME', '')
        # must be None for pytest
        self._environment_variables_dict['endpoint_url'] = os.environ.get('IBM_ENDPOINT_URL', None)
        self._environment_variables_dict['access_key_id'] = os.environ.get('IBM_ACCESS_KEY_ID', '')
        self._environment_variables_dict['secret_access_key'] = os.environ.get('IBM_SECRET_ACCESS_KEY', '')
        self._environment_variables_dict['bucket'] = os.environ.get('IBM_BUCKET', '')
        self._environment_variables_dict['key'] = os.environ.get('IBM_KEY', 'run-artifacts')

        # Parameters below related to 'install_ocp()'
        # MANDATORY for OCP install: install ocp version - insert version to install i.e. 'latest-4.8'
        self._environment_variables_dict['install_ocp_version'] = os.environ.get('INSTALL_OCP_VERSION', '')
        # There are 2 steps run_ibm_ocp_ipi_installer/verify_install_complete
        self._environment_variables_dict['install_step'] = os.environ.get('INSTALL_STEP', '')
        # dev or ga (/ocp-dev-preview/ or /ocp/ )
        self._environment_variables_dict['ocp_version_build'] = os.environ.get('OCP_VERSION_BUILD', '')
        # github repository
        self._environment_variables_dict['github_repository_short'] = os.environ.get('GITHUB_REPOSITORY_SHORT', '')

        # Parameters below related to 'install_resource()'
        # MANDATORY for OCP resource install: 'True' for install resources
        self._environment_variables_dict['install_ocp_resources'] = os.environ.get('INSTALL_OCP_RESOURCES', '')
        # cnv version
        self._environment_variables_dict['cnv_version'] = os.environ.get('CNV_VERSION', '')
        # ocs version
        self._environment_variables_dict['ocs_version'] = os.environ.get('OCS_VERSION', '')
        # number of ocs disk
        self._environment_variables_dict['num_ocs_disk'] = os.environ.get('NUM_OCS_DISK', 1)
        # install resources list
        self._environment_variables_dict['install_resources_list'] = os.environ.get('INSTALL_RESOURCES_LIST', '')

        # Parameters below related to 'install_ocp()' and 'install_resource()'
        # Mandatory: OCP environment flavor PERF or FUNC
        self._environment_variables_dict['ocp_env_flavor'] = os.environ.get('OCP_ENV_FLAVOR', 'FUNC')
        # IBM details
        self._environment_variables_dict['ibm_api_key'] = os.environ.get('IBM_API_KEY', '')
        # github token
        self._environment_variables_dict['github_token'] = os.environ.get('GITHUB_TOKEN', '')
        self.__ocp_env_flavor = self._environment_variables_dict['ocp_env_flavor']
        self._environment_variables_dict['worker_ids'] = os.environ.get(f'{self.__ocp_env_flavor}_WORKER_IDS',  "")
        self._environment_variables_dict['provision_ip'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_IP', '')
        # Placed on secret only
        self._environment_variables_dict['provision_private_key'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_PRIVATE_KEY', '')
        # For internal private key path
        self._environment_variables_dict['provision_private_key_path'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_PRIVATE_KEY_PATH', '')
        self._environment_variables_dict['container_private_key_path'] = os.environ.get('CONTAINER_PRIVATE_KEY_PATH', '')
        self._environment_variables_dict['provision_user'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_USER', '')
        self._environment_variables_dict['provision_oc_user'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_OC_USER', '')
        self._environment_variables_dict['provision_port'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_PORT', '')
        self._environment_variables_dict['provision_kubeadmin_password_path'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_KUBEADMIN_PASSWORD_PATH', '')
        self._environment_variables_dict['provision_kubeconfig_path'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_KUBECONFIG_PATH', '')
        self._environment_variables_dict['container_kubeconfig_path'] = os.environ.get('CONTAINER_KUBECONFIG_PATH', '')
        self._environment_variables_dict['provision_installer_path'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_INSTALLER_PATH', '')
        self._environment_variables_dict['provision_installer_cmd'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_INSTALLER_CMD', '')
        self._environment_variables_dict['provision_installer_log'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_INSTALLER_LOG', '')
        # remote ssh timeout - 3 hours for installation time
        self._environment_variables_dict['provision_timeout'] = os.environ.get(f'{self.__ocp_env_flavor}_PROVISION_TIMEOUT', '10800')
        # General timeout - 1.5 hours wait for pod/vm/upload data to elasticsearch
        self._environment_variables_dict['timeout'] = os.environ.get(f'{self.__ocp_env_flavor}_TIMEOUT', '3600')

        # Benchmark runner run artifacts url
        self._environment_variables_dict['run_artifacts_url'] = os.environ.get(f'{self.__ocp_env_flavor}_RUN_ARTIFACTS_URL', '')

        # Parameters below related to 'update_ci_status()'
        # CI run time
        self._environment_variables_dict['ci_minutes_time'] = os.environ.get('CI_MINUTES_TIME', 0)
        # Get this parameter from install resource process
        self._environment_variables_dict['ocp_resource_install_minutes_time'] = os.environ.get('OCP_RESOURCE_INSTALL_MINUTES_TIME', 0)
        # benchmark-operator last commit id
        self._environment_variables_dict['benchmark_operator_id'] = os.environ.get('BENCHMARK_OPERATOR_ID', '')
        # benchmark-wrapper last commit id
        self._environment_variables_dict['benchmark_wrapper_id'] = os.environ.get('BENCHMARK_WRAPPER_ID', '')

        # Node Selector functionality
        if self._environment_variables_dict['pin_node1']:
            self._environment_variables_dict['pin'] = 'true'
        else:
            self._environment_variables_dict['pin'] = 'false'
        # if pin_node2 not exist, get pin_node1 value
        if self._environment_variables_dict['pin_node1'] and not self._environment_variables_dict['pin_node2']:
            self._environment_variables_dict['pin_node2'] = self._environment_variables_dict['pin_node1']

        # ElasticSearch functionality
        if self._environment_variables_dict['elasticsearch'] and self._environment_variables_dict['elasticsearch_port']:
            self._environment_variables_dict['elasticsearch_url'] = f"http://{self._environment_variables_dict['elasticsearch']}:{self._environment_variables_dict['elasticsearch_port']}"
        else:
            self._environment_variables_dict['elasticsearch_url'] = ''

    @property
    def workloads_list(self):
        """
        This method is getter
        """
        return self._environment_variables_dict['workloads']

    @property
    def environment_variables_dict(self):
        """
        This method is getter
        """
        return self._environment_variables_dict

    @property
    def run_types_list(self):
        """
        This method is getter
        """
        return self._environment_variables_dict['run_types']

    @environment_variables_dict.setter
    def environment_variables_dict(self, value: dict):
        """
        This method is setter
        """
        self._environment_variables_dict = value


environment_variables = EnvironmentVariables()
