# Copyright 2016 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Google Stackdriver Logging API wrapper."""


from pkg_resources import get_distribution

__version__ = get_distribution("google-cloud-logging").version

from google.cloud.logging.client import Client


ASCENDING = "timestamp asc"
"""Query string to order by ascending timestamps."""
DESCENDING = "timestamp desc"
"""Query string to order by decending timestamps."""

__all__ = ["__version__", "ASCENDING", "Client", "DESCENDING"]
