# -*- coding: utf-8 -*-
# This file is automatically generated by setup.py

import os
import glob
import hashlib

def _get_md5(filename, blockSize=262144):
    with open(filename, 'rb') as fh:
        m = hashlib.md5()
        while True:
            block = fh.read(blockSize)
            if len(block) == 0:
                break
            m.update(block)
            
    return m.hexdigest()

def get_fingerprint():
    """
    Return a 'fingerprint' of the current LSL module state that is useful for
    tracking if the module has changed.
    """
    
    filenames = []
    for ext in ('.py', '.so'):
        filenames.extend( glob.glob(os.path.join(os.path.dirname(__file__), '*%s' % ext)) )
        filenames.extend( glob.glob(os.path.join(os.path.dirname(__file__), '*', '*%s' % ext)) )
        
    m = hashlib.md5()
    for filename in filenames:
        m.update(_get_md5(filename))
    return m.hexdigest()

version = '2.0.1'
full_version = '2.0.1'
short_version = '2.0'

