from ewoksppf import execute_graph
from ewokscore.tests.utils import assert_taskgraph_result


def submodel15(name):
    nodes = [
        {
            "id": "addtask1",
            "task_type": "ppfmethod",
            "task_identifier": "ewoksppf.tests.test_ppf_actors.pythonActorAdd.run",
        },
        {
            "id": "addtask2",
            "task_type": "ppfmethod",
            "task_identifier": "ewoksppf.tests.test_ppf_actors.pythonActorAdd.run",
        },
        {"id": "in", "task_type": "ppfport"},
        {"id": "out", "task_type": "ppfport"},
    ]

    links = [
        {"source": "in", "target": "addtask1", "all_arguments": True},
        {"source": "addtask1", "target": "addtask2", "all_arguments": True},
        {"source": "addtask2", "target": "out", "all_arguments": True},
    ]

    graph = {
        "graph": {"name": name},
        "links": links,
        "nodes": nodes,
    }

    return graph


def workflow15():
    nodes = [
        {
            "id": "addtask1",
            "inputs": {"value": 1},
            "task_type": "ppfmethod",
            "task_identifier": "ewoksppf.tests.test_ppf_actors.pythonActorAdd.run",
        },
        {
            "id": "addtask2",
            "task_type": "ppfmethod",
            "task_identifier": "ewoksppf.tests.test_ppf_actors.pythonActorAdd.run",
        },
        {
            "id": "submodel15a",
            "task_type": "graph",
            "task_identifier": submodel15("submodel15a"),
        },
        {
            "id": "submodel15b",
            "task_type": "graph",
            "task_identifier": submodel15("submodel15b"),
        },
    ]

    links = [
        {
            "source": "addtask1",
            "target": "submodel15a",
            "all_arguments": True,
            "sub_graph_nodes": {
                "sub_target": "in",
            },
        },
        {
            "source": "submodel15a",
            "target": "submodel15b",
            "all_arguments": True,
            "sub_graph_nodes": {
                "sub_source": "out",
                "sub_target": "in",
            },
        },
        {
            "source": "submodel15b",
            "target": "addtask2",
            "all_arguments": True,
            "sub_graph_nodes": {
                "sub_source": "out",
            },
        },
    ]

    graph = {
        "graph": {"name": "workflow15"},
        "links": links,
        "nodes": nodes,
    }

    expected_results = {
        "addtask1": {"ppfdict": {"value": 2}},
        ("submodel15a", "in"): {"ppfdict": {"value": 2}},
        ("submodel15a", "addtask1"): {"ppfdict": {"value": 3}},
        ("submodel15a", "addtask2"): {"ppfdict": {"value": 4}},
        ("submodel15a", "out"): {"ppfdict": {"value": 4}},
        ("submodel15b", "in"): {"ppfdict": {"value": 4}},
        ("submodel15b", "addtask1"): {"ppfdict": {"value": 5}},
        ("submodel15b", "addtask2"): {"ppfdict": {"value": 6}},
        ("submodel15b", "out"): {"ppfdict": {"value": 6}},
        "addtask2": {"ppfdict": {"value": 7}},
    }

    return graph, expected_results


def test_workflow15(ppf_logging, tmpdir):
    """Test connecting nodes from submodels directly"""
    varinfo = {"root_uri": str(tmpdir)}
    graph, expected = workflow15()
    execute_graph(graph, varinfo=varinfo)
    assert_taskgraph_result(graph, expected, varinfo=varinfo)
