# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pylode']

package_data = \
{'': ['*'], 'pylode': ['rdf/*']}

install_requires = \
['Markdown>=3.3.7,<4.0.0', 'dominate>=2.6.0,<3.0.0', 'rdflib>=6.1.1,<7.0.0']

setup_kwargs = {
    'name': 'pylode',
    'version': '3.0.4',
    'description': 'An OWL ontology documentation tool using Python, based on LODE.',
    'long_description': '.. image:: https://rawcdn.githack.com/RDFLib/pyLODE/b1ff1b1e19262cdc21ee28c7362b1690ca18e30b/img/pyLODE-250.png\n\n.. image:: https://badge.fury.io/py/pyLODE.svg\n    :target: https://badge.fury.io/py/pyLODE\n\npyLODE\n******\nAn OWL ontology documentation tool using Python, based on LODE.\n\nIn addition to making web page, human-readable forms of ontologies, pyLODE encourages ontology annotation *best\npractice* by only producing good results for well documented inputs! pyLODE defines what it considers \'well documented\'\nin sections below, e.g. `What pyLODE understands`_.\n\n----\n\n**A note on the v 3.x change**\n\nThis is pyLODE version 3.0.1 and it\'s vastly different from pyLODE 2.x. It doesn\'t yet handle all the various "profiles" that pyLODE 2.13.2 does, such as SKOS \'vocabularies\' & Profiles Vocabulary \'profiles\', it only handles OWL \'ontologies\', nor all the special data types, such as JSON literals, BUT, it generates HTML in a much more straightforward manner and the code is both more efficient and much more maintainable, which is why it\'s been made.\n\nv 3.x will eventually catch up to all of v 2.13.2\'s features.\n\nTo access v 2.13.2 of pyLODE, either `download it from PyPI <https://pypi.org/project/pyLODE/2.13.2/>`_ , `check it out from GitHub <https://github.com/RDFLib/pyLODE/releases/tag/2.13.2>`_ or access it via the `online service <http://pylode.surroundaustralia.com/>`_ .\n\n----\n\nContents\n========\n1. `Quick Intro`_\n2. Use_\n3. `What pyLODE understands`_\n4. Examples_\n5. Installation_\n6. `Differences from LODE`_\n7. `Releases`_\n8. License_\n9. Citation_\n10. Collaboration_\n11. Contacts_\n\n\nQuick Intro\n===========\nThe Live OWL Documentation Environment tool\n(`LODE <https://github.com/essepuntato/LODE>`__) is a well-known (in\nSemantic Web circles) Java & XSLT-based tool used to generate\nhuman-readable HTML documents for OWL and RDF ontologies. That tool is\nnow a bit dated (old-style HTML, use of older technologies like XSLT)\nand it\'s (`online version <https://www.essepuntato.it/lode>`__) is not always\nonline.\n\nThis tool is a complete re-implementation of LODE\'s functionality using\nPython and Python\'s RDF manipulation module,\n`rdflib <https://pypi.org/project/rdflib/>`__. An ontology to be\ndocumented is parsed and inspected using rdflib and HTML is generated\ndirectly, using Python\'s `dominate <https://pypi.org/project/dominate/>`__\npackage.\n\nUse\n===\n\nThe tool can be used in multiple ways:\n\n- BASH command line script\n    - pyLODE.sh in bin/\n- Windows EXE\n    - pyLODE.exe in bin/\n- Mac executable\n    - pyLODE in bin/\n- Python Script\n    - cli.py or module\n- as-a-service locally\n    - via the popular `Falcon framework <https://falconframework.org/>`__.\n    - see server.py in the main folder\n- as-a-service online\n    - hosted at https://pylode.surroundaustralia.com\n\nCommand line arguments\n----------------------\n\nThe BASH, Windows EXE and Python Script methods all use the same command line\narguments:\n\n::\n\n    usage: cli.py [-h] [-v] [-o OUTPUTFILE] [-c {true,false}] input\n\n    positional arguments:\n        input                 Input file location or URL\n\n    optional arguments:\n        -h, --help          show this help message and exit\n        -v, --version       show program\'s version number and exit\n        -o OUTPUTFILE,\n        --outputfile OUTPUTFILE\n                            A name you wish to assign to the output file. Will be\n                            postfixed with .html if not already added. If no\n                            output file is given, output will be printed to screen\n        -c {true,false},\n        --css {true,false}\n                            Whether (true) or not (false) to include CSS within an\n                            output HTML file.\n\nBasic Use\n^^^^^^^^^\n\n* as a Python script\n* executed in this directory\n\n::\n\n    python pylode examples/minimal.ttl -o minimal.html\n\nThis will produce the file ``minimal.html`` in this directory which should\nmatch exactly the file ``examples/minimal.html``.\n\n\nExamples\n========\n\nThe `examples/ directory <https://github.com/RDFLib/pyLODE/tree/master/examples>`_\ncontains multiple pairs of RDF & HTML files generated from them using this\nversion of pyLODE.\n\nYou can also see rendered versions of these example files online too:\n\n* `minimal.html <https://rdflib.dev/pyLODE/examples/ontdoc/minimal.html>`_\n* `agift.html <https://rdflib.dev/pyLODE/examples/ontdoc/agrif.html>`_\n* `alternates.html <https://rdflib.dev/pyLODE/examples/ontdoc/alternates.html>`_\n* `asgs.html <https://rdflib.dev/pyLODE/examples/ontdoc/asgs.html>`_\n\n\nWhat pyLODE understands\n=======================\n\npyLODE knows about definitional ontologies (``owl:Ontology``) and the major\nelements usually found in them, such as classes (``owl:Class`` or ``rdf:Class)\nand properties (``rdf:Property`` & ``owl:ObjectProperty`` etc.).\n\nTo see what properties for ontology, class and RDF property documentation\npyLODE currently supports, just look in the ``rdf_elements.py`` file. All\nelements\' properties supported are given in property lists there.\n\npyLODES won\'t just translate everything that you can describe in RDF into\nHTML! This is a conscious design choice to ensure that a certain conventional\nstyle of documented ontology is produced. However, support for new\nproperties and ontology patterns can be made - just create an Issue on\n`this project\'s Issue tracker <https://github.com/RDFLib/pyLODE/issues>`__.\n\nWhile it *does* know about instance data, such as Named Individuals, it\'s\nnot really designed to document large ontologies containing class instances.\n\nNotes on Agents\n---------------\npyLODE can understand both simple and complex Agent objects. You can use\nsimple string properties like ``dc:contributor "Nicholas J. Car"`` too if\nyou really must but better would be to take advantage of real Linked Data\nrepresentation, e.g. complex Agent objects with web addresses, emails,\naffiliations, ORCIDs and so on, e.g.:\n\n::\n\n    <ontology_x>\n        dct:creator [\n            sdo:name "Nicholas J. Car" ;\n            sdo:identifier <http://orcid.org/0000-0002-8742-7730> ;\n            sdo:affiliation [\n                sdo:name "SURROUND Australia Pty Ldt." ;\n                sdo:url "https://surroundaustralia.com"^^xsd:anyURI ;\n            ] ;\n        ] ;\n\nSee all the properties in ``rdf_elements.py:AGENT_PROPS`` for a list of\nall the Agent properties pyLODE can handle.\n\nInstallation\n============\n\npyLODE is `on PyPI <https://pypi.org/project/pyLODE/>`_, so you can install\nit using `pip <https://pypi.org/project/pip/>`_ as normal:\n\n::\n\n    pip install pylode\n\n\nDifferences from LODE\n=====================\n-  command line access\n\n   -  you can use this on your own desktop so you don\'t need me to\n      maintain a live service for use\n\n-  use of modern simple HTML\n\n   - no JavaScript: pyLODE generates static HTML pages\n\n-  catering for a wider range of ontology options such as:\n\n   -  schema.org ``domainIncludes`` & ``rangeIncludes`` for properties\n\n-  better Agent representation\n\n   - see the `Notes on Agents`_ section above\n\n-  smarter CURIES\n\n   -  pyLODE caches and looks up well-known prefixes to make more/better\n      CURIES\n   -  it tries to be smart with CURIE presentation by CURIE-ising all\n      URIs it finds, rather than printing them\n\n-  reference ontologies property labels\n\n   - pyLODE caches ~ 10 well-known ontologies (RDFS, SKOS etc), properties from which people often use for their ontology documentation. Where these properties are used, the background ontology\'s labels are use\n\n-  **active development**\n\n   -  pyLODE has been under active development since mid-2019 and is\n      still very much actively developed - it\'s not just staying still\n   -  it will be improved in foreseeable to cater for more and more things\n   -  recent ontology documentation initiatives such as the `MOD\n      Ontology <https://github.com/sifrproject/MOD-Ontology>`__ will be\n      handled, if requested\n\n\nReleases\n========\npyLODE is under continual and constant development. The current developers have a roadmap for enhancements in mind,\nwhich is given here, however, since this is an open source project, new developers may join the pyLODE dev community\nand change/add development priorities.\n\nCurrent Release\n---------------\n\nThe current release, as of May, 2022, is **3.0.4**.\n\nRelease Schedule\n----------------\n\n.. csv-table:: **pyLODE Release Schedule**\n   :header: "Version", "Date", "Description"\n   :widths: 15, 10, 30\n\n   **3.0.4**, **24 May 2022**, "Use of Poetry"\n   **3.0.2**, **24 May 2022**, "Support for preformatted skos:example literals"\n   3.0.1, 6 Jan 2022, "Direct HTML generation using dominate; easier to maintain and extend"\n   2.13.2, 21 December 2021, "Updated RDFlib to 6.1.1, improved test to properly use pytest"\n   2.10.0, 24 May 2021, "Update Windows EXE build process, simplified versioning"\n   2.9.1, 28 Apr 2021, "Support for ASCIIDOC format (OntDoc profile only)"\n   2.8.11, 28 Apr 2021, "Further changes for PyPI only"\n   2.8.10, 27 Apr 2021, "Further changes for PyPI only"\n   2.8.9, 27 Apr 2021, "PyPI enhancements only"\n   2.8.8, 27 Apr 2021, "Several small bugs fixed, auto-generation of version no. from Git tag"\n   2.8.6, 23 Feb 20201, "Fixing char encoding issues, updated examples, new test files style - per issue"\n   2.8.5, 5 Jan 20201, "Small enhancements to the Falcon server deployment option"\n   2.8.3, 3 July 2020, "Packaging bugfixes only"\n   2.7, 1 July 2020, "Much refactoring for new profile creation ease"\n   2.6, June 2020, "Supports PROF profiles as well as taxonomies & ontologies"\n   2.4, 27 May 2020, "Small improvements over 2.0"\n   2.0, 18 Apr 2020, "Includes multiple profiles - OWP & vocpub"\n   1.0, 15 Dec 2019, "Initial working release"\n\n\nLicense\n=======\nThis code is licensed using the BSD 3-Clause licence. See the `LICENSE\nfile <LICENSE>`_ for the deed. Note *Citation* below though for\nattribution.\n\n\nCitation\n========\nIf you use pyLODE, please leave the pyLODE logo with a hyperlink back\nhere in the top left of published HTML pages.\n\n\nCollaboration\n=============\nThe maintainers welcome any collaboration.\n\nIf you have suggestions, please email the contacts below or leave Issues\nin this repository\'s `Issue tracker <https://github.com/rdflib/pyLODE/issues>`_.\n\nBut the very best thing you could do is create a Pull Request for us to\naction!\n\n\nContacts\n========\n| *Author*:\n| **Nicholas Car**\n| *Data Architect*\n| `Kurrawong AI <https://kurrawong.net>`_\n| nick@kurrawong.net\n',
    'author': 'Nicholas Car',
    'author_email': 'nick@kurrawong.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
