from typing import Any, Dict, Union, cast

import attr

from ..models.fields import Fields
from ..types import UNSET, Unset


@attr.s(auto_attribs=True)
class LocationUpdate:
    """  """

    fields: Union[Fields, Unset] = UNSET
    name: Union[Unset, str] = UNSET
    parent_storage_id: Union[Unset, str] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        fields: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.fields, Unset):
            fields = self.fields.to_dict()

        name = self.name
        parent_storage_id = self.parent_storage_id

        field_dict: Dict[str, Any] = {}
        field_dict.update({})
        if fields is not UNSET:
            field_dict["fields"] = fields
        if name is not UNSET:
            field_dict["name"] = name
        if parent_storage_id is not UNSET:
            field_dict["parentStorageId"] = parent_storage_id

        return field_dict

    @staticmethod
    def from_dict(src_dict: Dict[str, Any]) -> "LocationUpdate":
        d = src_dict.copy()
        fields: Union[Fields, Unset] = UNSET
        _fields = d.pop("fields", UNSET)
        if _fields is not None and not isinstance(_fields, Unset):
            fields = Fields.from_dict(cast(Dict[str, Any], _fields))

        name = d.pop("name", UNSET)

        parent_storage_id = d.pop("parentStorageId", UNSET)

        location_update = LocationUpdate(
            fields=fields,
            name=name,
            parent_storage_id=parent_storage_id,
        )

        return location_update
